<?php
use Adianti\Core\AdiantiCoreTranslator;

/**
 * ApplicationTranslator
 *
 * @version    7.0
 * @package    util
 * @author     Pablo Dall'Oglio
 * @copyright  Copyright (c) 2006 Adianti Solutions Ltd. (http://www.adianti.com.br)
 * @license    http://www.adianti.com.br/framework-license
 */
class ApplicationTranslator
{
    private static $instance; // singleton instance
    private $lang;            // target language
    private $messages;
    private $sourceMessages;
    
    /**
     * Class Constructor
     */
    private function __construct()
    {
        $this->messages = [];
        $this->messages['en'] = [];
        $this->messages['en'][] = 'File not found';
        $this->messages['en'][] = 'Search';
        $this->messages['en'][] = 'Register';
        $this->messages['en'][] = 'Record saved';
        $this->messages['en'][] = 'Do you really want to delete ?';
        $this->messages['en'][] = 'Record deleted';
        $this->messages['en'][] = 'Function';
        $this->messages['en'][] = 'Table';
        $this->messages['en'][] = 'Tool';
        $this->messages['en'][] = 'Data';
        $this->messages['en'][] = 'Open';
        $this->messages['en'][] = 'New';
        $this->messages['en'][] = 'Save';
        $this->messages['en'][] = 'Find';
        $this->messages['en'][] = 'Edit';
        $this->messages['en'][] = 'Delete';
        $this->messages['en'][] = 'Cancel';
        $this->messages['en'][] = 'Yes';
        $this->messages['en'][] = 'No';
        $this->messages['en'][] = 'January';
        $this->messages['en'][] = 'February';
        $this->messages['en'][] = 'March';
        $this->messages['en'][] = 'April';
        $this->messages['en'][] = 'May';
        $this->messages['en'][] = 'June';
        $this->messages['en'][] = 'July';
        $this->messages['en'][] = 'August';
        $this->messages['en'][] = 'September';
        $this->messages['en'][] = 'October';
        $this->messages['en'][] = 'November';
        $this->messages['en'][] = 'December';
        $this->messages['en'][] = 'Today';
        $this->messages['en'][] = 'Close';
        $this->messages['en'][] = 'The field ^1 can not be less than ^2 characters';
        $this->messages['en'][] = 'The field ^1 can not be greater than ^2 characters';
        $this->messages['en'][] = 'The field ^1 can not be less than ^2';
        $this->messages['en'][] = 'The field ^1 can not be greater than ^2';
        $this->messages['en'][] = 'The field ^1 is required';
        $this->messages['en'][] = 'The field ^1 has not a valid CNPJ';
        $this->messages['en'][] = 'The field ^1 has not a valid CPF';
        $this->messages['en'][] = 'The field ^1 contains an invalid e-mail';
        $this->messages['en'][] = 'Permission denied';
        $this->messages['en'][] = 'Generate';
        $this->messages['en'][] = 'List';
        $this->messages['en'][] = 'Wrong password';
        $this->messages['en'][] = 'User not found';
        $this->messages['en'][] = 'User';
        $this->messages['en'][] = 'Users';
        $this->messages['en'][] = 'Password';
        $this->messages['en'][] = 'Login';
        $this->messages['en'][] = 'Name';
        $this->messages['en'][] = 'Group';
        $this->messages['en'][] = 'Groups';
        $this->messages['en'][] = 'Program';
        $this->messages['en'][] = 'Programs';
        $this->messages['en'][] = 'Back to the listing';
        $this->messages['en'][] = 'Controller';
        $this->messages['en'][] = 'Email';
        $this->messages['en'][] = 'Record Updated';
        $this->messages['en'][] = 'Password confirmation';
        $this->messages['en'][] = 'Front page';
        $this->messages['en'][] = 'Page name';
        $this->messages['en'][] = 'The passwords do not match';
        $this->messages['en'][] = 'Log in';
        $this->messages['en'][] = 'Date';
        $this->messages['en'][] = 'Column';
        $this->messages['en'][] = 'Operation';
        $this->messages['en'][] = 'Old value';
        $this->messages['en'][] = 'New value';
        $this->messages['en'][] = 'Database';
        $this->messages['en'][] = 'Profile';
        $this->messages['en'][] = 'Change password';
        $this->messages['en'][] = 'Leave empty to keep old password';
        $this->messages['en'][] = 'Results';
        $this->messages['en'][] = 'Invalid command';
        $this->messages['en'][] = '^1 records shown';
        $this->messages['en'][] = 'Administration';
        $this->messages['en'][] = 'SQL Panel';
        $this->messages['en'][] = 'Access Log';
        $this->messages['en'][] = 'Change Log';
        $this->messages['en'][] = 'SQL Log';
        $this->messages['en'][] = 'Clear form';
        $this->messages['en'][] = 'Send';
        $this->messages['en'][] = 'Message';
        $this->messages['en'][] = 'Messages';
        $this->messages['en'][] = 'Subject';
        $this->messages['en'][] = 'Message sent successfully';
        $this->messages['en'][] = 'Check as read';
        $this->messages['en'][] = 'Check as unread';
        $this->messages['en'][] = 'Action';
        $this->messages['en'][] = 'Read';
        $this->messages['en'][] = 'From';
        $this->messages['en'][] = 'Checked';
        $this->messages['en'][] = 'Object ^1 not found in ^2';
        $this->messages['en'][] = 'Notification';
        $this->messages['en'][] = 'Notifications';
        $this->messages['en'][] = 'Categories';
        $this->messages['en'][] = 'Send document';
        $this->messages['en'][] = 'My documents';
        $this->messages['en'][] = 'Shared with me';
        $this->messages['en'][] = 'Document';
        $this->messages['en'][] = 'File';
        $this->messages['en'][] = 'Title';
        $this->messages['en'][] = 'Description';
        $this->messages['en'][] = 'Category';
        $this->messages['en'][] = 'Submission date';
        $this->messages['en'][] = 'Archive date';
        $this->messages['en'][] = 'Upload';
        $this->messages['en'][] = 'Download';
        $this->messages['en'][] = 'Next';
        $this->messages['en'][] = 'Documents';
        $this->messages['en'][] = 'Permission';
        $this->messages['en'][] = 'Unit';
        $this->messages['en'][] = 'Units';
        $this->messages['en'][] = 'Add';
        $this->messages['en'][] = 'Active';
        $this->messages['en'][] = 'Activate/Deactivate';
        $this->messages['en'][] = 'Inactive user';
        $this->messages['en'][] = 'Send message';
        $this->messages['en'][] = 'Read messages';
        $this->messages['en'][] = 'An user with this login is already registered';
        $this->messages['en'][] = 'Access Stats';
        $this->messages['en'][] = 'Accesses';
        $this->messages['en'][] = 'Preferences';
        $this->messages['en'][] = 'Mail from';
        $this->messages['en'][] = 'SMTP Auth';
        $this->messages['en'][] = 'SMTP Host';
        $this->messages['en'][] = 'SMTP Port';
        $this->messages['en'][] = 'SMTP User';
        $this->messages['en'][] = 'SMTP Pass';
        $this->messages['en'][] = 'Ticket';
        $this->messages['en'][] = 'Open ticket';
        $this->messages['en'][] = 'Support mail';
        $this->messages['en'][] = 'Day';
        $this->messages['en'][] = 'Folders';
        $this->messages['en'][] = 'Compose';
        $this->messages['en'][] = 'Inbox';
        $this->messages['en'][] = 'Sent';
        $this->messages['en'][] = 'Archived';
        $this->messages['en'][] = 'Archive';
        $this->messages['en'][] = 'Recover';
        $this->messages['en'][] = 'Value';
        $this->messages['en'][] = 'View all';
        $this->messages['en'][] = 'Reload';
        $this->messages['en'][] = 'Back';
        $this->messages['en'][] = 'Clear';
        $this->messages['en'][] = 'View';
        $this->messages['en'][] = 'No records found';
        $this->messages['en'][] = 'Drawing successfully generated';
        $this->messages['en'][] = 'QR Codes successfully generated';
        $this->messages['en'][] = 'Barcodes successfully generated';
        $this->messages['en'][] = 'Document successfully generated';
        $this->messages['en'][] = 'Value';
        $this->messages['en'][] = 'User';
        $this->messages['en'][] = 'Password';
        $this->messages['en'][] = 'Port';
        $this->messages['en'][] = 'Database type';
        $this->messages['en'][] = 'Root user';
        $this->messages['en'][] = 'Root password';
        $this->messages['en'][] = 'Create database/user';
        $this->messages['en'][] = 'Test connection';
        $this->messages['en'][] = 'Database name';
        $this->messages['en'][] = 'Insert permissions/programs';
        $this->messages['en'][] = 'Database and user created successfully';
        $this->messages['en'][] = 'Permissions and programs successfully inserted';
        $this->messages['en'][] = 'Update config';
        $this->messages['en'][] = 'Configuration file: ^1 updated successfully';
        $this->messages['en'][] = 'Connection successfully completed';
        $this->messages['en'][] = "The database ^1 doesn't exists";
        $this->messages['en'][] = 'Permissions/programs successfully inserted';
        $this->messages['en'][] = 'Programs/permissions have already been inserted';
        $this->messages['en'][] = 'Installing your application';
        $this->messages['en'][] = 'PHP version verification and installed extensions';
        $this->messages['en'][] = 'PHP verification';
        $this->messages['en'][] = 'Directory and files verification';
        $this->messages['en'][] = 'Database configuration/creation';
        $this->messages['en'][] = 'Admin user';
        $this->messages['en'][] = 'Admin password';
        $this->messages['en'][] = 'Insert data';
        $this->messages['en'][] = 'Of database:';
        $this->messages['en'][] = 'Connecton to database ^1 failed';
        $this->messages['en'][] = 'Install';
        $this->messages['en'][] = 'Databases successfully installed';
        $this->messages['en'][] = 'Databases have already been installed';
        $this->messages['en'][] = 'Main unit';
        $this->messages['en'][] = 'Time';
        $this->messages['en'][] = 'Type';
        $this->messages['en'][] = 'Failed to read error log (^1)';
        $this->messages['en'][] = 'Error log (^1) is not writable by web server user, so the messages may be incomplete';
        $this->messages['en'][] = 'Check the owner of the log file. He must be the same as the web user (usually www-data, www, etc)';
        $this->messages['en'][] = 'Error log is empty or has not been configured correctly. Define the error log file, setting <b>error_log</b> at php.ini';
        $this->messages['en'][] = 'Errors are not being logged. Please turn <b>log_errors = On</b> at php.ini';
        $this->messages['en'][] = 'Errors are not currently being displayd because the <b>display_errors</b> is set to Off in php.ini';
        $this->messages['en'][] = 'This configuration is usually recommended for production, not development purposes';
        $this->messages['en'][] = 'The php.ini current location is <b>^1</b>';
        $this->messages['en'][] = 'The error log current location is <b>^1</b>';
        $this->messages['en'][] = 'PHP Log';
        $this->messages['en'][] = 'Database explorer';
        $this->messages['en'][] = 'Tables';
        $this->messages['en'][] = 'Report generated. Please, enable popups';
        $this->messages['en'][] = 'File saved';
        $this->messages['en'][] = 'Edit page';
        $this->messages['en'][] = 'Update page';
        $this->messages['en'][] = 'Module';
        $this->messages['en'][] = 'Directory';
        $this->messages['en'][] = 'Source code';
        $this->messages['en'][] = 'Invalid return';
        $this->messages['en'][] = 'Page';
        $this->messages['en'][] = 'Connection failed';
        $this->messages['en'][] = 'Summary database install';
        $this->messages['en'][] = 'No write permission on file';
        $this->messages['en'][] = 'In order to continue with the installation you must grant read permission to the directory';
        $this->messages['en'][] = 'In order to continue with the installation you must grant write permission to the directory';
        $this->messages['en'][] = 'Installed';
        $this->messages['en'][] = 'Path';
        $this->messages['en'][] = 'File';
        $this->messages['en'][] = 'Write';
        $this->messages['en'][] = 'Read';
        $this->messages['en'][] = 'In order to continue with the installation you must grant read permission to the file';
        $this->messages['en'][] = 'In order to continue with the installation you must grant write permission to the file';
        $this->messages['en'][] = 'Photo';
        $this->messages['en'][] = 'Reset password';
        $this->messages['en'][] = 'A new seed is required in the application.ini for security reasons';
        $this->messages['en'][] = 'Password reset';
        $this->messages['en'][] = 'Token expired. This operation is not allowed';
        $this->messages['en'][] = 'The password has been changed';
        $this->messages['en'][] = 'An user with this e-mail is already registered';
        $this->messages['en'][] = 'Invalid LDAP credentials';
        $this->messages['en'][] = 'Update menu overwriting existing file?';
        $this->messages['en'][] = 'Menu updated successfully';
        $this->messages['en'][] = 'Menu path';
        $this->messages['en'][] = 'Add to menu';
        $this->messages['en'][] = 'Remove from menu';
        $this->messages['en'][] = 'Item removed from menu';
        $this->messages['en'][] = 'Item added to menu';
        $this->messages['en'][] = 'Icon';
        $this->messages['en'][] = 'User registration';
        $this->messages['en'][] = 'The user registration is disabled';
        $this->messages['en'][] = 'The password reset is disabled';
        $this->messages['en'][] = 'Account created';
        $this->messages['en'][] = 'Create account';
        $this->messages['en'][] = 'If you want to reinstall edit the file app/config/install.ini and change installed = 1 to installed = 0. Erase the content in app/config/installed.ini too';
        $this->messages['en'][] = 'Authorization error';
        $this->messages['en'][] = 'Exit';
        $this->messages['en'][] = 'REST key not defined';
        $this->messages['en'][] = 'Local';
        $this->messages['en'][] = 'Remote';
        $this->messages['en'][] = 'Success';
        $this->messages['en'][] = 'Error';
        $this->messages['en'][] = 'Status';
        $this->messages['en'][] = 'Update permissions?';
        $this->messages['en'][] = 'Changed';
        $this->messages['en'][] = 'Add item above';
        $this->messages['en'][] = 'Add item below';
        $this->messages['en'][] = 'Add child item';
        $this->messages['en'][] = 'Remove item';
        $this->messages['en'][] = 'Move item';
        $this->messages['en'][] = 'Menu editor';
        $this->messages['en'][] = 'Order';
        $this->messages['en'][] = 'Label';
        $this->messages['en'][] = 'Color';
        $this->messages['en'][] = 'Menu saved';
        $this->messages['en'][] = 'Clone';
        $this->messages['en'][] = 'Impersonation';
        $this->messages['en'][] = 'Impersonated';
        $this->messages['en'][] = 'Execution trace';
        $this->messages['en'][] = 'Session';
        $this->messages['en'][] = 'Request Log';
        $this->messages['en'][] = 'Method';
        $this->messages['en'][] = 'Request';
        $this->messages['en'][] = 'Users by group';
        $this->messages['en'][] = 'Count';
        $this->messages['en'][] = 'Users by unit';
        $this->messages['en'][] = 'Save as PDF';
        $this->messages['en'][] = 'Save as CSV';
        $this->messages['en'][] = 'Save as XML';
        $this->messages['en'][] = 'Export';
        $this->messages['en'][] = 'System information';
        $this->messages['en'][] = 'RAM Memory';
        $this->messages['en'][] = 'Using/Total';
        $this->messages['en'][] = 'Free';
        $this->messages['en'][] = 'Percentage used';
        $this->messages['en'][] = 'CPU usage';
        $this->messages['en'][] = 'Vendor';
        $this->messages['en'][] = 'Model';
        $this->messages['en'][] = 'Current Frequency';
        $this->messages['en'][] = 'Webserver and Process';
        $this->messages['en'][] = 'Disk devices';
        $this->messages['en'][] = 'Device';
        $this->messages['en'][] = 'Mount point';
        $this->messages['en'][] = 'Filesystem';
        $this->messages['en'][] = 'Network devices';
        $this->messages['en'][] = 'Device name';
        $this->messages['en'][] = 'Port speed';
        $this->messages['en'][] = 'Sent';
        $this->messages['en'][] = 'Recieved';
        $this->messages['en'][] = 'Print';
        $this->messages['en'][] = 'Delete session var';
        $this->messages['en'][] = 'Impersonated by';
        $this->messages['en'][] = 'Unauthorized access to that unit';
        $this->messages['en'][] = 'Files diff';
        $this->messages['en'][] = 'Removed';
        $this->messages['en'][] = 'Equal';
        $this->messages['en'][] = 'Modified';
        $this->messages['en'][] = 'Terms of use and privacy policy';
        $this->messages['en'][] = 'Accept';
        $this->messages['en'][] = 'I have read and agree to the terms of use and privacy policy';
        $this->messages['en'][] = 'You need read and agree to the terms of use and privacy policy';
        $this->messages['en'][] = 'Login to your account';
        $this->messages['en'][] = 'You have just successfully logged in to ^1. If you do not recognize this login, contact technical support';
        $this->messages['en'][] = 'Current unit';
        $this->messages['en'][] = 'Choose the unit';
        $this->messages['en'][] = 'Change Unit';
        $this->messages['en'][] = 'Unit is required';
        $this->messages['en'][] = 'Unit changed!';
        $this->messages['en'][] = 'No permission to manage this record!';
        $this->messages['en'][] = 'Actions';
        $this->messages['en'][] = 'Refresh';
        $this->messages['en'][] = 'Clear filters';
        $this->messages['en'][] = 'Invalid username or password';
        $this->messages['en'][] = 'E-mail settings';
        $this->messages['en'][] = 'Security settings';
        $this->messages['en'][] = 'Enable strong password';
        $this->messages['en'][] = 'Maintenance';
        $this->messages['en'][] = 'Maintenance mode';
        $this->messages['en'][] = 'Message when attempting to log in';
        $this->messages['en'][] = 'Users who can log into the system';
        $this->messages['en'][] = 'When defining actions, they become mandatory, meaning the user will only be able to execute them if they are associated with a group';
        $this->messages['en'][] = 'Setup 2FA';
        $this->messages['en'][] = 'Continue';
        $this->messages['en'][] = 'You need to select a 2FA method';
        $this->messages['en'][] = 'Code sent';
        $this->messages['en'][] = 'Verify and activate';
        $this->messages['en'][] = 'Invalid verification code. Request a new code.';
        $this->messages['en'][] = 'Code expired. Request a new code.';
        $this->messages['en'][] = 'Error sending email:';
        $this->messages['en'][] = 'Verification code';
        $this->messages['en'][] = 'Your verification code is: ^1';
        $this->messages['en'][] = '2FA by email successfully activated!';
        $this->messages['en'][] = 'Enter the 6-digit code sent to your email';
        $this->messages['en'][] = 'VERIFY';
        $this->messages['en'][] = 'Two-step verification';
        $this->messages['en'][] = 'Enter the 6-digit Google Authenticator code';
        $this->messages['en'][] = "Haven't received the code?";
        $this->messages['en'][] = "Disable";
        $this->messages['en'][] = "Do you really want to disable 2FA ?";
        $this->messages['en'][] = "2FA successfully disabled!";
        $this->messages['en'][] = "Configure Email Authentication";
        $this->messages['en'][] = "Confirm your email";
        $this->messages['en'][] = "You will receive verification codes at this email:";
        $this->messages['en'][] = "Enter the code";
        $this->messages['en'][] = "Resend code";
        $this->messages['en'][] = "2FA by Google Authenticator successfully activated!";
        $this->messages['en'][] = "Install the app";
        $this->messages['en'][] = 'Scan the QR Code';
        $this->messages['en'][] = 'Or enter the code manually:';
        $this->messages['en'][] = 'Check the configuration';
        $this->messages['en'][] = 'Enter the code shown in Google Authenticator';
        $this->messages['en'][] = 'Enable Google reCAPTCHA';
        $this->messages['en'][] = 'Enable 2FA by Google Authenticator';
        $this->messages['en'][] = 'Enable 2FA by email';
        $this->messages['en'][] = 'Email subject';
        $this->messages['en'][] = 'Email content';
        $this->messages['en'][] = 'Available variables:';
        $this->messages['en'][] = 'reCAPTCHA verification failed. Please try again.';
        $this->messages['en'][] = '2FA by email is not enabled in the system';
        $this->messages['en'][] = '2FA by Google Aythenticator is not enabled in the system';
        $this->messages['en'][] = 'Destination table';
        $this->messages['en'][] = 'Destination field';
        $this->messages['en'][] = 'Origin field (CSV)';
        $this->messages['en'][] = 'Mapping of columns';
        $this->messages['en'][] = 'Import';
        $this->messages['en'][] = 'Format not supported. Please upload a CSV file.';
        $this->messages['en'][] = 'Error creating a copy of the file in the tmp folder. Please check the permissions of the tmp folder of your project.';
        $this->messages['en'][] = 'No file was uploaded.';
        $this->messages['en'][] = 'No valid mapping defined.';
        $this->messages['en'][] = 'Unsupported driver:';
        $this->messages['en'][] = 'CSV file could not be opened.';
        $this->messages['en'][] = 'Import completed successfully!<br> Processed records: ^1';
        $this->messages['en'][] = 'JSON configuration';
        $this->messages['en'][] = 'Internal chat';
        $this->messages['en'][] = 'To use the internal chat, it is necessary to have provided the Firebase JSON configuration.';
        $this->messages['en'][] = 'Enable internal chat';
        $this->messages['en'][] = 'User groups unauthorized for chat usage';
        $this->messages['en'][] = 'Users unauthorized for chat usage';
        $this->messages['en'][] = 'Disconnect user?';
        $this->messages['en'][] = 'Last action executed';
        $this->messages['en'][] = 'Disconnect user';
        $this->messages['en'][] = 'New conversation';
        $this->messages['en'][] = 'Start conversation';
        $this->messages['en'][] = 'New group conversation';
        $this->messages['en'][] = 'Group name';
        $this->messages['en'][] = 'Participants';
        $this->messages['en'][] = 'Add group participants';
        $this->messages['en'][] = 'Data importing';
        $this->messages['en'][] = 'User monitoring';
        $this->messages['en'][] = 'Navigation';
        $this->messages['en'][] = 'Restrict system access to a single browser tab';
        $this->messages['en'][] = 'Security';
        $this->messages['en'][] = 'Allows system users to chat with each other or in groups';
        $this->messages['en'][] = 'When enabled, only authorized users will be able to access the system';
        $this->messages['en'][] = 'Strong password';
        $this->messages['en'][] = 'Requires that the user password contains 8 characters, including numbers, uppercase letters, lowercase letters, and special characters';
        $this->messages['en'][] = 'When enabled, adds reCAPTCHA verification to the login screen for protection against bots';
        $this->messages['en'][] = 'Enable 2FA by email';
        $this->messages['en'][] = 'When enabled, users will be able to use 2FA by email';
        $this->messages['en'][] = 'Enable 2FA by Google Authenticator';
        $this->messages['en'][] = 'When enabled, users will be able to use 2FA by Google Authenticator';
        $this->messages['en'][] = 'Chat rules';
        $this->messages['en'][] = 'Import data';

        //fim
        
        $this->messages['pt'] = [];
        $this->messages['pt'][] = 'Arquivo não encontrado';
        $this->messages['pt'][] = 'Buscar';
        $this->messages['pt'][] = 'Cadastrar';
        $this->messages['pt'][] = 'Registro salvo';
        $this->messages['pt'][] = 'Deseja realmente excluir ?';
        $this->messages['pt'][] = 'Registro excluído';
        $this->messages['pt'][] = 'Função';
        $this->messages['pt'][] = 'Tabela';
        $this->messages['pt'][] = 'Ferramenta';
        $this->messages['pt'][] = 'Dados';
        $this->messages['pt'][] = 'Abrir';
        $this->messages['pt'][] = 'Novo';
        $this->messages['pt'][] = 'Salvar';
        $this->messages['pt'][] = 'Buscar';
        $this->messages['pt'][] = 'Editar';
        $this->messages['pt'][] = 'Excluir';
        $this->messages['pt'][] = 'Cancelar';
        $this->messages['pt'][] = 'Sim';
        $this->messages['pt'][] = 'Não';
        $this->messages['pt'][] = 'Janeiro';
        $this->messages['pt'][] = 'Fevereiro';
        $this->messages['pt'][] = 'Março';
        $this->messages['pt'][] = 'Abril';
        $this->messages['pt'][] = 'Maio';
        $this->messages['pt'][] = 'Junho';
        $this->messages['pt'][] = 'Julho';
        $this->messages['pt'][] = 'Agosto';
        $this->messages['pt'][] = 'Setembro';
        $this->messages['pt'][] = 'Outubro';
        $this->messages['pt'][] = 'Novembro';
        $this->messages['pt'][] = 'Dezembro';
        $this->messages['pt'][] = 'Hoje';
        $this->messages['pt'][] = 'Fechar';
        $this->messages['pt'][] = 'O campo ^1 não pode ter menos de ^2 caracteres';
        $this->messages['pt'][] = 'O campo ^1 não pode ter mais de ^2 caracteres';
        $this->messages['pt'][] = 'O campo ^1 não pode ser menor que ^2';
        $this->messages['pt'][] = 'O campo ^1 não pode ser maior que ^2';
        $this->messages['pt'][] = 'O campo ^1 é obrigatório';
        $this->messages['pt'][] = 'O campo ^1 não contém um CNPJ válido';
        $this->messages['pt'][] = 'O campo ^1 não contém um CPF válido';
        $this->messages['pt'][] = 'O campo ^1 contém um e-mail inválido';
        $this->messages['pt'][] = 'Permissão negada';
        $this->messages['pt'][] = 'Gerar';
        $this->messages['pt'][] = 'Listar';
        $this->messages['pt'][] = 'Senha errada';
        $this->messages['pt'][] = 'Usuário não encontrado';
        $this->messages['pt'][] = 'Usuário';
        $this->messages['pt'][] = 'Usuários';
        $this->messages['pt'][] = 'Senha';
        $this->messages['pt'][] = 'Login';
        $this->messages['pt'][] = 'Nome';
        $this->messages['pt'][] = 'Grupo';
        $this->messages['pt'][] = 'Grupos';
        $this->messages['pt'][] = 'Programa';
        $this->messages['pt'][] = 'Programas';
        $this->messages['pt'][] = 'Voltar para a listagem';
        $this->messages['pt'][] = 'Classe de controle';
        $this->messages['pt'][] = 'Email';
        $this->messages['pt'][] = 'Registro atualizado';
        $this->messages['pt'][] = 'Confirma senha';
        $this->messages['pt'][] = 'Tela inicial';
        $this->messages['pt'][] = 'Nome da Tela';
        $this->messages['pt'][] = 'As senhas não conferem';
        $this->messages['pt'][] = 'Entrar';
        $this->messages['pt'][] = 'Data';
        $this->messages['pt'][] = 'Coluna';
        $this->messages['pt'][] = 'Operação';
        $this->messages['pt'][] = 'Valor antigo';
        $this->messages['pt'][] = 'Valor novo';
        $this->messages['pt'][] = 'Banco de dados';
        $this->messages['pt'][] = 'Perfil';
        $this->messages['pt'][] = 'Mudar senha';
        $this->messages['pt'][] = 'Deixe vazio para manter a senha anterior';
        $this->messages['pt'][] = 'Resultados';
        $this->messages['pt'][] = 'Comando inválido';
        $this->messages['pt'][] = '^1 registros exibidos';
        $this->messages['pt'][] = 'Administração';
        $this->messages['pt'][] = 'Painel SQL';
        $this->messages['pt'][] = 'Log de acesso';
        $this->messages['pt'][] = 'Log de alterações';
        $this->messages['pt'][] = 'Log de SQL';
        $this->messages['pt'][] = 'Limpar formulário';
        $this->messages['pt'][] = 'Enviar';
        $this->messages['pt'][] = 'Mensagem';
        $this->messages['pt'][] = 'Mensagens';
        $this->messages['pt'][] = 'Assunto';
        $this->messages['pt'][] = 'Mensagem enviada com sucesso';
        $this->messages['pt'][] = 'Marcar como lida';
        $this->messages['pt'][] = 'Marcar como não lida';
        $this->messages['pt'][] = 'Ação';
        $this->messages['pt'][] = 'Ler';
        $this->messages['pt'][] = 'Origem';
        $this->messages['pt'][] = 'Verificado';
        $this->messages['pt'][] = 'Objeto ^1 não encontrado em ^2';
        $this->messages['pt'][] = 'Notificação';
        $this->messages['pt'][] = 'Notificações';
        $this->messages['pt'][] = 'Categorias';
        $this->messages['pt'][] = 'Enviar documentos';
        $this->messages['pt'][] = 'Meus documentos';
        $this->messages['pt'][] = 'Compartilhados comigo';
        $this->messages['pt'][] = 'Documento';
        $this->messages['pt'][] = 'Arquivo';
        $this->messages['pt'][] = 'Título';
        $this->messages['pt'][] = 'Descrição';
        $this->messages['pt'][] = 'Categoria';
        $this->messages['pt'][] = 'Data de submissão';
        $this->messages['pt'][] = 'Data de arquivamento';
        $this->messages['pt'][] = 'Upload';
        $this->messages['pt'][] = 'Download';
        $this->messages['pt'][] = 'Próximo';
        $this->messages['pt'][] = 'Documentos';
        $this->messages['pt'][] = 'Permissão';
        $this->messages['pt'][] = 'Unidade';
        $this->messages['pt'][] = 'Unidades';
        $this->messages['pt'][] = 'Adicionar';
        $this->messages['pt'][] = 'Ativo';
        $this->messages['pt'][] = 'Ativar/desativar';
        $this->messages['pt'][] = 'Usuário inativo';
        $this->messages['pt'][] = 'Envia mensagem';
        $this->messages['pt'][] = 'Ler mensagens';
        $this->messages['pt'][] = 'Um usuário já está cadastrado com este login';
        $this->messages['pt'][] = 'Estatísticas de acesso';
        $this->messages['pt'][] = 'Acessos';
        $this->messages['pt'][] = 'Preferências';
        $this->messages['pt'][] = 'E-mail de origem';
        $this->messages['pt'][] = 'Autentica SMTP';
        $this->messages['pt'][] = 'Host SMTP';
        $this->messages['pt'][] = 'Porta SMTP';
        $this->messages['pt'][] = 'Usuário SMTP';
        $this->messages['pt'][] = 'Senha SMTP';
        $this->messages['pt'][] = 'Ticket';
        $this->messages['pt'][] = 'Abrir ticket';
        $this->messages['pt'][] = 'Email de suporte';
        $this->messages['pt'][] = 'Dia';
        $this->messages['pt'][] = 'Pastas';
        $this->messages['pt'][] = 'Escrever';
        $this->messages['pt'][] = 'Entrada';
        $this->messages['pt'][] = 'Enviados';
        $this->messages['pt'][] = 'Arquivados';
        $this->messages['pt'][] = 'Arquivar';
        $this->messages['pt'][] = 'Recuperar';
        $this->messages['pt'][] = 'Valor';
        $this->messages['pt'][] = 'Ver todos';
        $this->messages['pt'][] = 'Recarregar';
        $this->messages['pt'][] = 'Voltar';
        $this->messages['pt'][] = 'Limpar';
        $this->messages['pt'][] = 'Visualizar';
        $this->messages['pt'][] = 'Nenhum registro foi encontrado';
        $this->messages['pt'][] = 'Desenho gerado com sucesso';
        $this->messages['pt'][] = 'QR codes gerados com sucesso';
        $this->messages['pt'][] = 'Códigos de barra gerados com sucesso';
        $this->messages['pt'][] = 'Documento gerado com sucesso';
        $this->messages['pt'][] = 'Valor';
        $this->messages['pt'][] = 'Usuário';
        $this->messages['pt'][] = 'Senha';
        $this->messages['pt'][] = 'Porta';
        $this->messages['pt'][] = 'Tipo da base de dados';
        $this->messages['pt'][] = 'Usuário admin';
        $this->messages['pt'][] = 'Senha do usuário admin';
        $this->messages['pt'][] = 'Criar base de dados/usuário';
        $this->messages['pt'][] = 'Testar conexão';
        $this->messages['pt'][] = 'Nome da base de dados';
        $this->messages['pt'][] = 'Inserir permissões/programas';
        $this->messages['pt'][] = 'Base de dados e usuário criado com sucesso';
        $this->messages['pt'][] = 'Permissões e programas inseridos com sucesso';
        $this->messages['pt'][] = 'Atualizar config';
        $this->messages['pt'][] = 'Arquivo de configuração: ^1 atualizado com sucesso';
        $this->messages['pt'][] = 'Conexão realizada com sucesso';
        $this->messages['pt'][] = 'A base de dados ^1 não existe';
        $this->messages['pt'][] = 'Permissões/programas inseridos com sucesso';
        $this->messages['pt'][] = 'Os programas/permissões já foram inseridos';
        $this->messages['pt'][] = 'Instalando a sua aplicação';
        $this->messages['pt'][] = 'Verificação da versão do PHP e extensões instaladas';
        $this->messages['pt'][] = 'Verificação do PHP';
        $this->messages['pt'][] = 'Verificação de diretórios e arquivos';
        $this->messages['pt'][] = 'Configuração/criação de base de dados';
        $this->messages['pt'][] = 'Usuário admin';
        $this->messages['pt'][] = 'Senha do usuário admin';
        $this->messages['pt'][] = 'Inserir dados';
        $this->messages['pt'][] = 'Da base de dados:';
        $this->messages['pt'][] = 'A conexão com a base de dados ^1 falhou';
        $this->messages['pt'][] = 'Instalar';
        $this->messages['pt'][] = 'Bases de dados instaladas com sucesso';
        $this->messages['pt'][] = 'As bases de dados já foram instaladas';
        $this->messages['pt'][] = 'Unidade principal';
        $this->messages['pt'][] = 'Hora';
        $this->messages['pt'][] = 'Tipo';
        $this->messages['pt'][] = 'Falha ao ler o log de erros (^1)';
        $this->messages['pt'][] = 'O log de erros (^1) não permite escrita pelo usuário web, assim as mensagens devem estar incompletas';
        $this->messages['pt'][] = 'Revise o proprietário do arquivo de log. Ele deve ser igual ao usuário web (geralmente www-data, www, etc)';
        $this->messages['pt'][] = 'Log de erros está vazio ou não foi configurado corretamente. Defina o arquivo de log de erros, configurando <b>error_log</b> no php.ini';
        $this->messages['pt'][] = 'Erros não estão sendo registrados. Por favor, mude <b>log_errors = On</b> no php.ini';
        $this->messages['pt'][] = 'Erros não estão atualmente sendo exibidos por que <b>display_errors</b> está configurado para Off no php.ini';
        $this->messages['pt'][] = 'Esta configuração normalmente é recomendada para produção, não para o propósito de desenvolvimento';
        $this->messages['pt'][] = 'A localização atual do php.ini é <b>^1</b>';
        $this->messages['pt'][] = 'A localização atual do log de erros é <b>^1</b>';
        $this->messages['pt'][] = 'Log do PHP';
        $this->messages['pt'][] = 'Database explorer';
        $this->messages['pt'][] = 'Tabelas';
        $this->messages['pt'][] = 'Relatório gerado. Favor, habilitar os popups';
        $this->messages['pt'][] = 'Arquivo salvo';
        $this->messages['pt'][] = 'Editar página';
        $this->messages['pt'][] = 'Atualizar página';
        $this->messages['pt'][] = 'Módulo';
        $this->messages['pt'][] = 'Diretório';
        $this->messages['pt'][] = 'Código-fonte';
        $this->messages['pt'][] = 'Retorno inválido';
        $this->messages['pt'][] = 'Página';
        $this->messages['pt'][] = 'Falhas na conexão';
        $this->messages['pt'][] = 'Resumo da instalação da base de dados';
        $this->messages['pt'][] = 'Sem permissão de escrita no arquivo';
        $this->messages['pt'][] = 'Para que seja possível continuar com a instalação você deve conceder permissão de leitura para o diretório';
        $this->messages['pt'][] = 'Para que seja possível continuar com a instalação você deve conceder permissão de escrita para o diretório';
        $this->messages['pt'][] = 'Instalada';
        $this->messages['pt'][] = 'Diretório';
        $this->messages['pt'][] = 'Arquivo';
        $this->messages['pt'][] = 'Escrita';
        $this->messages['pt'][] = 'Leitura';
        $this->messages['pt'][] = 'Para que seja possível continuar com a instalação você deve conceder permissão de leitura para o arquivo';
        $this->messages['pt'][] = 'Para que seja possível continuar com a instalação você deve conceder permissão de escrita para o arquivo';
        $this->messages['pt'][] = 'Foto';
        $this->messages['pt'][] = 'Redefinir senha';
        $this->messages['pt'][] = 'Uma nova seed é necessária no application.ini por motivos de segurança';
        $this->messages['pt'][] = 'Troca de senha';
        $this->messages['pt'][] = 'Token expirado. Esta operação não é permitida';
        $this->messages['pt'][] = 'A senha foi alterada';
        $this->messages['pt'][] = 'Um usuário já está cadastrado com este e-mail';
        $this->messages['pt'][] = 'Credenciais LDAP erradas';
        $this->messages['pt'][] = 'Atualizar o menu sobregravando arquivo existente?';
        $this->messages['pt'][] = 'Menu atualizado com sucesso';
        $this->messages['pt'][] = 'Caminho menu';
        $this->messages['pt'][] = 'Adiciona ao menu';
        $this->messages['pt'][] = 'Remove do menu';
        $this->messages['pt'][] = 'Item removido do menu';
        $this->messages['pt'][] = 'Item adicionado ao menu';
        $this->messages['pt'][] = 'Ícone';
        $this->messages['pt'][] = 'Cadastro de usuário';
        $this->messages['pt'][] = 'O cadastro de usuários está desabilitado';
        $this->messages['pt'][] = 'A recuperação de senhas está desabilitada';
        $this->messages['pt'][] = 'Conta criada';
        $this->messages['pt'][] = 'Criar conta';
        $this->messages['pt'][] = 'Se você deseja reinstalar, edite o arquivo app/config/install.ini e altere installed = 1 para installed = 0. Apague o conteúdo no arquivo app/config/install.ini também';
        $this->messages['pt'][] = 'Erro de autorização';
        $this->messages['pt'][] = 'Sair';
        $this->messages['pt'][] = 'Chave REST não definida';
        $this->messages['pt'][] = 'Local';
        $this->messages['pt'][] = 'Remoto';
        $this->messages['pt'][] = 'Sucesso';
        $this->messages['pt'][] = 'Erro';
        $this->messages['pt'][] = 'Status';
        $this->messages['pt'][] = 'Atualiza permissões?';
        $this->messages['pt'][] = 'Modificado';
        $this->messages['pt'][] = 'Adiciona item acima';
        $this->messages['pt'][] = 'Adiciona item abaixo';
        $this->messages['pt'][] = 'Adiciona item filho';
        $this->messages['pt'][] = 'Remover item';
        $this->messages['pt'][] = 'Mover item';
        $this->messages['pt'][] = 'Editor de menu';
        $this->messages['pt'][] = 'Ordenação';
        $this->messages['pt'][] = 'Rótulo';
        $this->messages['pt'][] = 'Cor';
        $this->messages['pt'][] = 'Menu salvo';
        $this->messages['pt'][] = 'Clonar';
        $this->messages['pt'][] = 'Personificar';
        $this->messages['pt'][] = 'Personificado';
        $this->messages['pt'][] = 'Rastreamento da execução';
        $this->messages['pt'][] = 'Sessão';
        $this->messages['pt'][] = 'Log de request';
        $this->messages['pt'][] = 'Método';
        $this->messages['pt'][] = 'Requisição';
        $this->messages['pt'][] = 'Usuários por grupo';
        $this->messages['pt'][] = 'Quantidade';
        $this->messages['pt'][] = 'Usuários por unidade';
        $this->messages['pt'][] = 'Salvar como PDF';
        $this->messages['pt'][] = 'Salvar como CSV';
        $this->messages['pt'][] = 'Salvar como XML';
        $this->messages['pt'][] = 'Exportar';
        $this->messages['pt'][] = 'Informações do sistema';
        $this->messages['pt'][] = 'Memória RAM';
        $this->messages['pt'][] = 'Usando/Total';
        $this->messages['pt'][] = 'Disponível';
        $this->messages['pt'][] = 'Percentual usado';
        $this->messages['pt'][] = 'Uso da CPU';
        $this->messages['pt'][] = 'Fornecedor';
        $this->messages['pt'][] = 'Modelo';
        $this->messages['pt'][] = 'Frequência atual';
        $this->messages['pt'][] = 'Servidor web e processos';
        $this->messages['pt'][] = 'Dispositivos de disco';
        $this->messages['pt'][] = 'Dispositivo';
        $this->messages['pt'][] = 'Ponto de montagem';
        $this->messages['pt'][] = 'Sistema de arquivos';
        $this->messages['pt'][] = 'Dispositivos de rede';
        $this->messages['pt'][] = 'Nome do dispositivo';
        $this->messages['pt'][] = 'Velocidade da porta';
        $this->messages['pt'][] = 'Enviados';
        $this->messages['pt'][] = 'Recebidos';
        $this->messages['pt'][] = 'Imprimir';
        $this->messages['pt'][] = 'Exclui variável de sessão';
        $this->messages['pt'][] = 'Personificado por';
        $this->messages['pt'][] = 'Acesso não autorizado à esta unidade';
        $this->messages['pt'][] = 'Diferença de arquivos';
        $this->messages['pt'][] = 'Removido';
        $this->messages['pt'][] = 'Igual';
        $this->messages['pt'][] = 'Modificado';
        $this->messages['pt'][] = 'Termo de uso e política de privacidade';
        $this->messages['pt'][] = 'Aceitar';
        $this->messages['pt'][] = 'Eu li e concordo com os termos de uso e política de privacidade';
        $this->messages['pt'][] = 'Você precisa ler e concordar com os termos de uso e política de privacidade';
        $this->messages['pt'][] = 'Login realizado em sua conta';
        $this->messages['pt'][] = 'Você acaba de efetuar login com sucesso no ^1. Se não reconhece esse login, entre em contato com o suporte técnico.';
        $this->messages['pt'][] = 'Unidade atual';
        $this->messages['pt'][] = 'Escolha a unidade';
        $this->messages['pt'][] = 'Trocar Unidade';
        $this->messages['pt'][] = 'A unidade é obrigatória';
        $this->messages['pt'][] = 'Unidade alterada!';
        $this->messages['pt'][] = 'Sem permissão para gerenciar este registro!';
        $this->messages['pt'][] = 'Ações';
        $this->messages['pt'][] = 'Atualizar';
        $this->messages['pt'][] = 'Limpar filtros';
        $this->messages['pt'][] = 'Usuário ou senha incorretos';
        $this->messages['pt'][] = 'Configurações de e-mail';
        $this->messages['pt'][] = 'Configurações de segurança';
        $this->messages['pt'][] = 'Habilitar senha forte';
        $this->messages['pt'][] = 'Manutenção';
        $this->messages['pt'][] = 'Modo manutenção';
        $this->messages['pt'][] = 'Mensagem ao tentar realizar o login';
        $this->messages['pt'][] = 'Usuários que podem logar no sistema';
        $this->messages['pt'][] = 'Ao definir as ações, elas se tornam obrigatórias, ou seja o usuário só irá conseguir executar se elas estiverem associadas a um grupo';
        $this->messages['pt'][] = 'Configurar 2FA';
        $this->messages['pt'][] = 'Continuar';
        $this->messages['pt'][] = 'Você precisa selecionar um método 2FA';
        $this->messages['pt'][] = 'Código enviado';
        $this->messages['pt'][] = 'Verificar e ativar';
        $this->messages['pt'][] = 'Código de verificação inválido. Solicite um novo código.';
        $this->messages['pt'][] = 'Código expirado. Solicite um novo código.';
        $this->messages['pt'][] = 'Erro ao enviar email:';
        $this->messages['pt'][] = 'Código de Verificação';
        $this->messages['pt'][] = 'Seu código de verificação é: ^1';
        $this->messages['pt'][] = '2FA por email ativado com sucesso!';
        $this->messages['pt'][] = 'Digite o código de 6 dígitos enviado para seu email';
        $this->messages['pt'][] = 'VERIFICAR';
        $this->messages['pt'][] = 'Verificação em duas etapas';
        $this->messages['pt'][] = 'Digite o código de 6 dígitos do Google Authenticator';
        $this->messages['pt'][] = 'Não recebeu o código?';
        $this->messages['pt'][] = 'Desabilitar';
        $this->messages['pt'][] = "Tem certeza que deseja desabilitar o 2FA ?";
        $this->messages['pt'][] = "2FA desativado com sucesso!";
        $this->messages['pt'][] = "Configurar Autenticação por Email";
        $this->messages['pt'][] = "Confirme seu email";
        $this->messages['pt'][] = "Você receberá os códigos de verificação neste email:";
        $this->messages['pt'][] = "Digite o código";
        $this->messages['pt'][] = "Reenviar código";
        $this->messages['pt'][] = '2FA por Google Authenticator ativado com sucesso!';
        $this->messages['pt'][] = 'Instale o aplicativo';
        $this->messages['pt'][] = 'Escaneie o QR Code';
        $this->messages['pt'][] = 'Ou insira o código manualmente:';
        $this->messages['pt'][] = 'Verifique a configuração';
        $this->messages['pt'][] = 'Digite o código mostrado no Google Authenticator';
        $this->messages['pt'][] = 'Habilitar Google Recaptcha';
        $this->messages['pt'][] = 'Ativar 2FA pelo Google Authenticator';
        $this->messages['pt'][] = 'Ativar 2FA por email';
        $this->messages['pt'][] = 'Assunto do email';
        $this->messages['pt'][] = 'Conteúdo do email';
        $this->messages['pt'][] = 'Variáveis disponíveis:';
        $this->messages['pt'][] = 'Verificação do reCAPTCHA falhou. Tente novamente.';
        $this->messages['pt'][] = '2FA por email não está ativado no sistema';
        $this->messages['pt'][] = '2FA por Google Authenticator não está ativado no sistema';
        $this->messages['pt'][] = 'Tabela de destino';
        $this->messages['pt'][] = 'Campo de destino';
        $this->messages['pt'][] = 'Campo de origem (CSV)';
        $this->messages['pt'][] = 'Mapeamento de colunas';
        $this->messages['pt'][] = 'Importar';
        $this->messages['pt'][] = 'Formato não suportado. Por favor, envie um arquivo CSV.';
        $this->messages['pt'][] = 'Erro ao criar uma cópia do arquivo na pasta tmp. Por favor, verifique as permissões da pasta tmp do seu projeto.';
        $this->messages['pt'][] = 'Nenhum arquivo foi enviado.';
        $this->messages['pt'][] = 'Nenhum mapeamento válido definido.';
        $this->messages['pt'][] = 'Driver não suportado:';
        $this->messages['pt'][] = 'Não foi possível abrir o arquivo CSV.';
        $this->messages['pt'][] = 'Importação realizada com sucesso!<br> Registros processados: ^1';
        $this->messages['pt'][] = 'Configuração em JSON';
        $this->messages['pt'][] = 'Chat interno';
        $this->messages['pt'][] = 'Para utilizar o chat interno é necessário ter informado a configuração em JSON do Firebase.';
        $this->messages['pt'][] = 'Habilitar chat inerno';
        $this->messages['pt'][] = 'Grupos de usuário sem autorização para utilizar o chat';
        $this->messages['pt'][] = 'Usuários sem autorização para utilizar o chat';
        $this->messages['pt'][] = 'Desconectar o usuário?';
        $this->messages['pt'][] = 'Última ação executada';
        $this->messages['pt'][] = 'Desconectar usuário';
        $this->messages['pt'][] = 'Nova conversa';
        $this->messages['pt'][] = 'Iniciar conversa';
        $this->messages['pt'][] = 'Nova conversa em grupo';
        $this->messages['pt'][] = 'Nome do grupo';
        $this->messages['pt'][] = 'Participantes';
        $this->messages['pt'][] = 'Adicionar participantes ao grupo';
        $this->messages['pt'][] = 'Importação de dados';
        $this->messages['pt'][] = 'Monitoramento de usuários';
        $this->messages['pt'][] = 'Navegação';
        $this->messages['pt'][] = 'Restringir o acesso do sistema a uma única aba do navegador';
        $this->messages['pt'][] = 'Segurança';
        $this->messages['pt'][] = 'Permite que os usuários do sistema conversem entre si ou em grupos';
        $this->messages['pt'][] = 'Ao habilitar, apenas os usuários autorizados poderão acessar o sistema';
        $this->messages['pt'][] = 'Senha forte';
        $this->messages['pt'][] = 'Exige que a senha do usuário contenha 8 caracteres, incluindo números, letras maiúsculas, minúsculas e caracteres especiais';
        $this->messages['pt'][] = 'Quando habilitado, adiciona verificação reCAPTCHA na tela de login para proteção contra bots';
        $this->messages['pt'][] = 'Habilitar 2FA por e-mail';
        $this->messages['pt'][] = 'Quando habilitado, os usuários poderão usar 2FA por e-mail';
        $this->messages['pt'][] = 'Habilitar 2FA por Google Authenticator';
        $this->messages['pt'][] = 'Quando habilitado, os usuários poderão usar 2FA por Google Authenticator';
        $this->messages['pt'][] = 'Regras do chat';
        $this->messages['pt'][] = 'Importar dados';

        //fim
        
        $this->messages['es'] = [];
        $this->messages['es'][] = 'Archivo no encontrado';
        $this->messages['es'][] = 'Buscar';
        $this->messages['es'][] = 'Registrar';
        $this->messages['es'][] = 'Registro guardado';
        $this->messages['es'][] = 'Deseas realmente eliminar ?';
        $this->messages['es'][] = 'Registro eliminado';
        $this->messages['es'][] = 'Función';
        $this->messages['es'][] = 'Tabla';
        $this->messages['es'][] = 'Herramienta';
        $this->messages['es'][] = 'Datos';
        $this->messages['es'][] = 'Abrir';
        $this->messages['es'][] = 'Nuevo';
        $this->messages['es'][] = 'Guardar';
        $this->messages['es'][] = 'Buscar';
        $this->messages['es'][] = 'Modificar';
        $this->messages['es'][] = 'Eliminar';
        $this->messages['es'][] = 'Cancelar';
        $this->messages['es'][] = 'Sí';
        $this->messages['es'][] = 'No';
        $this->messages['es'][] = 'Enero';
        $this->messages['es'][] = 'Febrero';
        $this->messages['es'][] = 'Marzo';
        $this->messages['es'][] = 'Abril';
        $this->messages['es'][] = 'Mayo';
        $this->messages['es'][] = 'Junio';
        $this->messages['es'][] = 'Julio';
        $this->messages['es'][] = 'Agosto';
        $this->messages['es'][] = 'Septiembre';
        $this->messages['es'][] = 'Octubre';
        $this->messages['es'][] = 'Noviembre';
        $this->messages['es'][] = 'Diciembre';
        $this->messages['es'][] = 'Hoy';
        $this->messages['es'][] = 'Cerrar';
        $this->messages['es'][] = 'El campo ^1 no puede tener menos de ^2 caracteres';
        $this->messages['es'][] = 'El campo ^1 no puede tener mas de ^2 caracteres';
        $this->messages['es'][] = 'El campo ^1 no puede ser menor que ^2';
        $this->messages['es'][] = 'El campo ^1 no puede ser mayor que ^2';
        $this->messages['es'][] = 'El campo ^1 es obligatorio';
        $this->messages['es'][] = 'El campo ^1 no contiene un CNPJ válido';
        $this->messages['es'][] = 'El campo ^1 no contiene un CPF válido';
        $this->messages['es'][] = 'El campo ^1 contiene um e-mail inválido';
        $this->messages['es'][] = 'Permiso denegado';
        $this->messages['es'][] = 'Generar';
        $this->messages['es'][] = 'Listar';
        $this->messages['es'][] = 'Contraseña incorrecta';
        $this->messages['es'][] = 'Usuário no encontrado';
        $this->messages['es'][] = 'Usuário';
        $this->messages['es'][] = 'Usuários';
        $this->messages['es'][] = 'Contraseña';
        $this->messages['es'][] = 'Login';
        $this->messages['es'][] = 'Nombre';
        $this->messages['es'][] = 'Grupo';
        $this->messages['es'][] = 'Grupos';
        $this->messages['es'][] = 'Programa';
        $this->messages['es'][] = 'Programas';
        $this->messages['es'][] = 'Volver al listado';
        $this->messages['es'][] = 'Classe de control';
        $this->messages['es'][] = 'Email';
        $this->messages['es'][] = 'Registro actualizado';
        $this->messages['es'][] = 'Confirme contraseña';
        $this->messages['es'][] = 'Pantalla inicial';
        $this->messages['es'][] = 'Nombre da la Pantalla';
        $this->messages['es'][] = 'Las contraseñas no conciden';
        $this->messages['es'][] = 'Ingresar';
        $this->messages['es'][] = 'Fecha';
        $this->messages['es'][] = 'Columna';
        $this->messages['es'][] = 'Operación';
        $this->messages['es'][] = 'Valor anterior';
        $this->messages['es'][] = 'Valor nuevo';
        $this->messages['es'][] = 'Base de datos';
        $this->messages['es'][] = 'Perfil';
        $this->messages['es'][] = 'Cambiar contraseña';
        $this->messages['es'][] = 'Deje vacio para mantener la contraseña anterior';
        $this->messages['es'][] = 'Resultados';
        $this->messages['es'][] = 'Comando inválido';
        $this->messages['es'][] = '^1 registros  exhibidos';
        $this->messages['es'][] = 'Administración';
        $this->messages['es'][] = 'Panel SQL';
        $this->messages['es'][] = 'Log de acceso';
        $this->messages['es'][] = 'Log de modificaciones';
        $this->messages['es'][] = 'Log de SQL';
        $this->messages['es'][] = 'Limpiar formulário';
        $this->messages['es'][] = 'Enviar';
        $this->messages['es'][] = 'Mensaje';
        $this->messages['es'][] = 'Mensajes';
        $this->messages['es'][] = 'Asunto';
        $this->messages['es'][] = 'Mensaje enviada exitosamente';
        $this->messages['es'][] = 'Marcar como leída';
        $this->messages['es'][] = 'Marcar como no leída';
        $this->messages['es'][] = 'Acción';
        $this->messages['es'][] = 'Leer';
        $this->messages['es'][] = 'Origen';
        $this->messages['es'][] = 'Verificado';
        $this->messages['es'][] = 'Objeto ^1 no encontrado en ^2';
        $this->messages['es'][] = 'Notificación';
        $this->messages['es'][] = 'Notificaciones';
        $this->messages['es'][] = 'Categorias';
        $this->messages['es'][] = 'Enviar documentos';
        $this->messages['es'][] = 'Mis documentos';
        $this->messages['es'][] = 'Compartidos conmigo';
        $this->messages['es'][] = 'Documento';
        $this->messages['es'][] = 'Archivo';
        $this->messages['es'][] = 'Título';
        $this->messages['es'][] = 'Descripción';
        $this->messages['es'][] = 'Categoria';
        $this->messages['es'][] = 'Fecha de envio';
        $this->messages['es'][] = 'Fecha de archivamiento';
        $this->messages['es'][] = 'Upload';
        $this->messages['es'][] = 'Download';
        $this->messages['es'][] = 'Siguiente';
        $this->messages['es'][] = 'Documentos';
        $this->messages['es'][] = 'Permiso';
        $this->messages['es'][] = 'Unidad';
        $this->messages['es'][] = 'Unidades';
        $this->messages['es'][] = 'Agrega';
        $this->messages['es'][] = 'Activo';
        $this->messages['es'][] = 'Activar/desactivar';
        $this->messages['es'][] = 'Usuário desactivado';
        $this->messages['es'][] = 'Envia mensaje';
        $this->messages['es'][] = 'Leer mensaje';
        $this->messages['es'][] = 'Un usuário ya está registrado con este login';
        $this->messages['es'][] = 'Estadisticas de acceso';
        $this->messages['es'][] = 'Accesos';
        $this->messages['es'][] = 'Preferencias';
        $this->messages['es'][] = 'E-mail de origen';
        $this->messages['es'][] = 'Autentica SMTP';
        $this->messages['es'][] = 'Host SMTP';
        $this->messages['es'][] = 'Puerta SMTP';
        $this->messages['es'][] = 'Usuário SMTP';
        $this->messages['es'][] = 'Contraseña SMTP';
        $this->messages['es'][] = 'Ticket';
        $this->messages['es'][] = 'Abrir ticket';
        $this->messages['es'][] = 'Email de soporte';
        $this->messages['es'][] = 'Dia';
        $this->messages['es'][] = 'Carpetas';
        $this->messages['es'][] = 'Componer';
        $this->messages['es'][] = 'Entrada';
        $this->messages['es'][] = 'Enviados';
        $this->messages['es'][] = 'Archivados';
        $this->messages['es'][] = 'Archivar';
        $this->messages['es'][] = 'Recuperar';
        $this->messages['es'][] = 'Valor';
        $this->messages['es'][] = 'Ver todos';
        $this->messages['es'][] = 'Recargar';
        $this->messages['es'][] = 'Volver';
        $this->messages['es'][] = 'Limpiar';
        $this->messages['es'][] = 'Visualizar';
        $this->messages['es'][] = 'Ningun registro fue encontrado';
        $this->messages['es'][] = 'Diseño generado con éxito';
        $this->messages['es'][] = 'QR codes generados con éxito';
        $this->messages['es'][] = 'Códigos de barra generados con éxito';
        $this->messages['es'][] = 'Documento generado con éxito';
        $this->messages['es'][] = 'Valor';
        $this->messages['es'][] = 'Usuário';
        $this->messages['es'][] = 'Contraseña';
        $this->messages['es'][] = 'Puerta';
        $this->messages['es'][] = 'Tipo de base de datos';
        $this->messages['es'][] = 'Usuário admin';
        $this->messages['es'][] = 'Contraseña del usuário admin';
        $this->messages['es'][] = 'Crear base de datos/usuário';
        $this->messages['es'][] = 'Testear conexión';
        $this->messages['es'][] = 'Nombree de la base de datos';
        $this->messages['es'][] = 'Ingresar permisos/programas';
        $this->messages['es'][] = 'Base de datos y usuário creado con éxito';
        $this->messages['es'][] = 'Permisos y programas agregados con éxito';
        $this->messages['es'][] = 'Actualizar configuración';
        $this->messages['es'][] = 'Archivo de configuración: ^1 actualizado con éxito';
        $this->messages['es'][] = 'Conexión realizada con éxito';
        $this->messages['es'][] = 'La base de datos ^1 no existe';
        $this->messages['es'][] = 'Permisos/programas agregados con éxito';
        $this->messages['es'][] = 'Los programas/permisos ya fueron agregados';
        $this->messages['es'][] = 'Instalando en su aplicación';
        $this->messages['es'][] = 'Verficación de la version del PHP y extenciones instaladas';
        $this->messages['es'][] = 'Verficación del PHP';
        $this->messages['es'][] = 'Verficación de directorios y archivos';
        $this->messages['es'][] = 'Configuración/creación de la base de datos';
        $this->messages['es'][] = 'Usuário admin';
        $this->messages['es'][] = 'Contraseña del usuário admin';
        $this->messages['es'][] = 'Ingresar datos';
        $this->messages['es'][] = 'De la base de datos:';
        $this->messages['es'][] = 'La conexión con la base de datos ^1 falló';
        $this->messages['es'][] = 'Instalar';
        $this->messages['es'][] = 'Bases de datos instaladas con éxito';
        $this->messages['es'][] = 'Las bases de datos ya fueron instaladas';
        $this->messages['es'][] = 'Unidad principal';
        $this->messages['es'][] = 'Hora';
        $this->messages['es'][] = 'Tipo';
        $this->messages['es'][] = 'Falla al leer el log de errores (^1)';
        $this->messages['es'][] = 'El log de errores (^1) no permite escritura por el usuário web, así que los mensajes deben estar incompletos';
        $this->messages['es'][] = 'Revise el propietario del archivo de log. Debe ser igual al usuário web (generalmente www-data, www, etc)';
        $this->messages['es'][] = 'Log de errores está vacio o no fue configurado correctamente. Defina el archivo de log de errores, configurando <b>error_log</b> en el php.ini';
        $this->messages['es'][] = 'Errores no estan siendo registrados. Por favor, modifique <b>log_errors = On</b> en el php.ini';
        $this->messages['es'][] = 'Errores no estan actualmente siendo mostrados porque <b>display_errors</b> está configurado para Off en el php.ini';
        $this->messages['es'][] = 'Esta configuración normalmente es recomendada para producción, no para el propósito de desarrollo';
        $this->messages['es'][] = 'La ubicación actual del php.ini es <b>^1</b>';
        $this->messages['es'][] = 'La ubicación actual del log de errores es <b>^1</b>';
        $this->messages['es'][] = 'Log del PHP';
        $this->messages['es'][] = 'Database explorer';
        $this->messages['es'][] = 'Tablas';
        $this->messages['es'][] = 'Reporte generado. Favor, habilitar los popups';
        $this->messages['es'][] = 'Archivo guardado';
        $this->messages['es'][] = 'Modificar página';
        $this->messages['es'][] = 'Actualizar página';
        $this->messages['es'][] = 'Módulo';
        $this->messages['es'][] = 'Directório';
        $this->messages['es'][] = 'Código-fuente';
        $this->messages['es'][] = 'Retorno inválido';
        $this->messages['es'][] = 'Página';
        $this->messages['es'][] = 'Fallas en la conexión';
        $this->messages['es'][] = 'Resumen de la instalación de la base de datos';
        $this->messages['es'][] = 'Sin permiso de escritura en el archivo';
        $this->messages['es'][] = 'Para que sea posible continuar con la instalación usted debe conceder permisos de lectura para el directório';
        $this->messages['es'][] = 'Para que sea posible continuar con la instalación usted debe conceder permisos de escritura para el directório';
        $this->messages['es'][] = 'Instalada';
        $this->messages['es'][] = 'Directório';
        $this->messages['es'][] = 'Archivo';
        $this->messages['es'][] = 'Escritura';
        $this->messages['es'][] = 'Lectura';
        $this->messages['es'][] = 'Para que sea posible continuar con la instalación usted debe conceder permisos de lectura para el archivo';
        $this->messages['es'][] = 'Para que sea posible continuar con la instalación usted debe conceder permisos de escritura para el archivo';
        $this->messages['es'][] = 'Foto';
        $this->messages['es'][] = 'Cambiar contraseña';
        $this->messages['es'][] = 'Una nueva seed es necesaria en application.ini por motivos de seguridad';
        $this->messages['es'][] = 'Cambiar la contraseña';
        $this->messages['es'][] = 'Token expirado. Esta operación no está permitida';
        $this->messages['es'][] = 'La contraseña fue modificada';
        $this->messages['es'][] = 'Un usuário ya está registrado con este e-mail';
        $this->messages['es'][] = 'Credenciales LDAP incorrectas';
        $this->messages['es'][] = 'Actualizar el menu reemplazando el archivo existente?';
        $this->messages['es'][] = 'Menu actualizado con éxito';
        $this->messages['es'][] = 'Dirección del menu';
        $this->messages['es'][] = 'Agregar al menu';
        $this->messages['es'][] = 'Eliminar del menu';
        $this->messages['es'][] = 'Iten eliminado del menu';
        $this->messages['es'][] = 'Iten agregado al menu';
        $this->messages['es'][] = 'Ícono';
        $this->messages['es'][] = 'Registro de usuário';
        $this->messages['es'][] = 'El registro de usuários está desactivado';
        $this->messages['es'][] = 'La recuperación de contraseña está desactivada';
        $this->messages['es'][] = 'Cuenta creada';
        $this->messages['es'][] = 'Crear cuenta';
        $this->messages['es'][] = 'Si desea reinstalar, edite el archivo app/config/install.ini y cambie installed = 1 a installed = 0. Borre el contenido en el archivo app/config/install.ini también';
        $this->messages['es'][] = 'Error de autorización';
        $this->messages['es'][] = 'Salir';
        $this->messages['es'][] = 'Clave REST no definida';
        $this->messages['es'][] = 'Local';
        $this->messages['es'][] = 'Remoto';
        $this->messages['es'][] = 'Éxito';
        $this->messages['es'][] = 'Error';
        $this->messages['es'][] = 'Estado';
        $this->messages['es'][] = 'Actualizar permisos?';
        $this->messages['es'][] = 'Cambiado';
        $this->messages['es'][] = 'Agregar elemento arriba';
        $this->messages['es'][] = 'Agregar elemento abajo';
        $this->messages['es'][] = 'Adiciona item hijo';
        $this->messages['es'][] = 'Excluir item';
        $this->messages['es'][] = 'Mover elemento';
        $this->messages['es'][] = 'Editor de menú';
        $this->messages['es'][] = 'Ordenación';
        $this->messages['es'][] = 'Etiqueta';
        $this->messages['es'][] = 'Color';
        $this->messages['es'][] = 'Menú guardado';
        $this->messages['es'][] = 'Clonar';
        $this->messages['es'][] = 'Personificar';
        $this->messages['es'][] = 'Personificado';
        $this->messages['es'][] = 'Rastreo de ejecución';
        $this->messages['es'][] = 'Sesión';
        $this->messages['es'][] = 'Log de request';
        $this->messages['es'][] = 'Método';
        $this->messages['es'][] = 'Request';
        $this->messages['es'][] = 'Usuarios por grupo';
        $this->messages['es'][] = 'Cantidad';
        $this->messages['es'][] = 'Usuarios por unidad';
        $this->messages['es'][] = 'Guardar como PDF';
        $this->messages['es'][] = 'Guardar como CSV';
        $this->messages['es'][] = 'Guardar como XML';
        $this->messages['es'][] = 'Exportar';
        $this->messages['es'][] = 'Informaciones del sistema';
        $this->messages['es'][] = 'Memória RAM';
        $this->messages['es'][] = 'Utilizando/Total';
        $this->messages['es'][] = 'Disponible';
        $this->messages['es'][] = 'Porcentaje utilizado';
        $this->messages['es'][] = 'Uso de CPU';
        $this->messages['es'][] = 'Proveedor';
        $this->messages['es'][] = 'Modelo';
        $this->messages['es'][] = 'Frecuencia actual';
        $this->messages['es'][] = 'Servidor web y procesos';
        $this->messages['es'][] = 'Dispositivos de disco';
        $this->messages['es'][] = 'Dispositivo';
        $this->messages['es'][] = 'Punto de montaje';
        $this->messages['es'][] = 'Sistema de archivos';
        $this->messages['es'][] = 'Dispositivos de red';
        $this->messages['es'][] = 'Nombre del dispositivo';
        $this->messages['es'][] = 'Velocidad de la puerta';
        $this->messages['es'][] = 'Enviados';
        $this->messages['es'][] = 'Recebidos';
        $this->messages['es'][] = 'Imprimir';
        $this->messages['es'][] = 'Eliminar variable de sesión';
        $this->messages['es'][] = 'Personificado por';
        $this->messages['es'][] = 'Acceso prohibido a esta unidad';
        
        $this->messages['es'][] = 'Diferencia de archivo';
        $this->messages['es'][] = 'Remoto';
        $this->messages['es'][] = 'Igual';
        $this->messages['es'][] = 'Cambiado';
        $this->messages['es'][] = 'Términos de uso y política de privacidad';
        $this->messages['es'][] = 'Aceptar';
        $this->messages['es'][] = 'He leído y acepto los términos de uso y la política de privacidad';
        $this->messages['es'][] = 'Necesita leer y aceptar los términos de uso y la política de privacidad';
        $this->messages['es'][] = 'Ingrese a su cuenta';
        $this->messages['es'][] = 'Acaba de iniciar sesión correctamente en ^1. Si no reconoce este inicio de sesión, comuníquese con el soporte técnico';
        $this->messages['es'][] = 'Unidad atual';
        $this->messages['es'][] = 'Elige la unidad';
        $this->messages['es'][] = 'Cambiar Unidad';
        $this->messages['es'][] = 'La unidad es obligatoria';
        $this->messages['es'][] = '¡Unidad cambiada!';
        $this->messages['es'][] = '¡Sin permiso para gestionar este registro!';
        $this->messages['es'][] = 'Accións';
        $this->messages['es'][] = 'Actualizar';
        $this->messages['es'][] = 'Borrar filtros';
        $this->messages['es'][] = 'Usuario o contraseña incorrectos';
        $this->messages['es'][] = 'Configuraciones de correo electrónico';
        $this->messages['es'][] = 'Configuraciones de seguridad';
        $this->messages['es'][] = 'Contraseña fuerte';
        $this->messages['es'][] = 'Mantenimiento';
        $this->messages['es'][] = 'Modo mantenimiento';
        $this->messages['es'][] = 'Mensaje al intentar iniciar sesión"';
        $this->messages['es'][] = 'Usuarios que pueden iniciar sesión en el sistema';
        $this->messages['es'][] = 'Al definir las acciones, estas se vuelven obligatorias, es decir, el usuario solo podrá ejecutarlas si están asociadas a un grupo';
        $this->messages['es'][] = 'Configurar 2FA';
        $this->messages['es'][] = 'Continuar';
        $this->messages['es'][] = 'Necesitas seleccionar un método 2FA';
        $this->messages['es'][] = 'Código enviado';
        $this->messages['es'][] = 'Verificar y activar';
        $this->messages['es'][] = 'Código de verificación inválido. Solicita un nuevo código.';
        $this->messages['es'][] = 'Código expirado. Solicita un nuevo código.';
        $this->messages['es'][] = 'Error al enviar correo:';
        $this->messages['es'][] = 'Código de verificación';
        $this->messages['es'][] = 'Tu código de verificación es: ^1';
        $this->messages['es'][] = '¡2FA por correo activado exitosamente!';
        $this->messages['es'][] = 'Ingresa el código de 6 dígitos enviado a tu correo';
        $this->messages['es'][] = 'VERIFICAR';
        $this->messages['es'][] = 'Verificación en dos pasos';
        $this->messages['es'][] = 'Ingresa el código de 6 dígitos de Google Authenticator';
        $this->messages['es'][] = "¿No has recibido el código?";
        $this->messages['es'][] = "Deshabilitar";
        $this->messages['es'][] = "¿Realmente deseas deshabilitar 2FA?";
        $this->messages['es'][] = "¡2FA deshabilitado exitosamente!";
        $this->messages['es'][] = "Configurar Autenticación por Correo";
        $this->messages['es'][] = "Confirma tu correo";
        $this->messages['es'][] = "Recibirás códigos de verificación en este correo:";
        $this->messages['es'][] = "Ingresa el código";
        $this->messages['es'][] = "Reenviar código";
        $this->messages['es'][] = "¡2FA por Google Authenticator activado exitosamente!";
        $this->messages['es'][] = "Instalar la aplicación";
        $this->messages['es'][] = 'Escanea el código QR';
        $this->messages['es'][] = 'O ingresa el código manualmente:';
        $this->messages['es'][] = 'Verifica la configuración';
        $this->messages['es'][] = 'Ingresa el código mostrado en Google Authenticator';
        $this->messages['es'][] = 'Habilitar Google reCAPTCHA';
        $this->messages['es'][] = 'Habilitar 2FA por Google Authenticator';
        $this->messages['es'][] = 'Habilitar 2FA por correo';
        $this->messages['es'][] = 'Asunto del correo';
        $this->messages['es'][] = 'Contenido del correo';
        $this->messages['es'][] = 'Variables disponibles:';
        $this->messages['es'][] = 'Verificación reCAPTCHA fallida. Por favor intenta de nuevo.';
        $this->messages['es'][] = 'El 2FA por correo no está habilitado en el sistema';
        $this->messages['es'][] = 'El 2FA por Google Authenticator no está habilitado en el sistema';
        $this->messages['es'][] = 'Tabla de destino';
        $this->messages['es'][] = 'Campo de destino';
        $this->messages['es'][] = 'Campo de origen (CSV)';
        $this->messages['es'][] = 'Mapeo de columnas';
        $this->messages['es'][] = 'Importar';
        $this->messages['es'][] = 'Formato no soportado. Por favor, suba un archivo CSV.';
        $this->messages['es'][] = 'Error al crear una copia del archivo en la carpeta tmp. Por favor, verifique los permisos de la carpeta tmp de su proyecto.';
        $this->messages['es'][] = 'Ningún archivo fue subido.';
        $this->messages['es'][] = 'Ningún mapeo válido definido.';
        $this->messages['es'][] = 'Controlador no soportado:';
        $this->messages['es'][] = 'No se pudo abrir el archivo CSV.';
        $this->messages['es'][] = '¡Importación realizada con éxito!<br> Registros procesados: ^1';
        $this->messages['es'][] = 'Configuración en JSON';
        $this->messages['es'][] = 'Chat interno';
        $this->messages['es'][] = 'Para utilizar el chat interno, es necesario haber proporcionado la configuración JSON de Firebase.';
        $this->messages['es'][] = 'Habilitar chat interno';
        $this->messages['es'][] = 'Grupos de usuarios no autorizados para usar el chat';
        $this->messages['es'][] = 'Usuarios no autorizados para usar el chat';
        $this->messages['es'][] = '¿Desconectar al usuario?';
        $this->messages['es'][] = 'Última acción ejecutada';
        $this->messages['es'][] = 'Desconectar usuario';
        $this->messages['es'][] = 'Nueva conversación';
        $this->messages['es'][] = 'Iniciar conversación';
        $this->messages['es'][] = 'Nueva conversación grupal';
        $this->messages['es'][] = 'Nombre del grupo';
        $this->messages['es'][] = 'Participantes';
        $this->messages['es'][] = 'Añadir participantes al grupo';
        $this->messages['es'][] = 'Importación de datos';
        $this->messages['es'][] = 'Supervisión de usuarios';
        $this->messages['es'][] = 'Navegación';
        $this->messages['es'][] = 'Restringir el acceso del sistema a una única pestaña del navegador';
        $this->messages['es'][] = 'Seguridad';
        $this->messages['es'][] = 'Permite que los usuarios del sistema conversen entre sí o en grupos';
        $this->messages['es'][] = 'Cuando está habilitado, solo los usuarios autorizados podrán acceder al sistema';
        $this->messages['es'][] = 'Contraseña fuerte';
        $this->messages['es'][] = 'Requiere que la contraseña del usuario contenga 8 caracteres, incluyendo números, letras mayúsculas, minúsculas y caracteres especiales';
        $this->messages['es'][] = 'Cuando está habilitado, añade verificación reCAPTCHA en la pantalla de inicio de sesión para protección contra bots';
        $this->messages['es'][] = 'Habilitar 2FA por correo electrónico';
        $this->messages['es'][] = 'Cuando está habilitado, los usuarios podrán usar 2FA por correo electrónico';
        $this->messages['es'][] = 'Habilitar 2FA por Google Authenticator';
        $this->messages['es'][] = 'Cuando está habilitado, los usuarios podrán usar 2FA por Google Authenticator';
        $this->messages['es'][] = 'Reglas del chat';
        $this->messages['es'][] = 'Importar datos';

        $this->messages['en'][] = "Id"; 
        $this->messages['it'][] = "id"; 
        $this->messages['pt'][] = "Id"; 

        $this->messages['en'][] = "Dhcreation"; 
        $this->messages['it'][] = "Dhcreazione"; 
        $this->messages['pt'][] = "Data de criação"; 

        $this->messages['en'][] = "Dhchanged"; 
        $this->messages['it'][] = "Dhcambiato"; 
        $this->messages['pt'][] = "Data de alteração"; 

        $this->messages['en'][] = "Ddhdeletion"; 
        $this->messages['it'][] = "Dbhcancellazione"; 
        $this->messages['pt'][] = "Exclusão"; 

        $this->messages['en'][] = "Nuser create"; 
        $this->messages['it'][] = "Ncreazione utente"; 
        $this->messages['pt'][] = "Usuário de criação"; 

        $this->messages['en'][] = "Nuser change"; 
        $this->messages['it'][] = "Cambio utente"; 
        $this->messages['pt'][] = "Usuário de alteração"; 

        $this->messages['en'][] = "Nuser deletion"; 
        $this->messages['it'][] = "Neliminazione dell'utente"; 
        $this->messages['pt'][] = "Usuário de exclusão"; 

        $this->messages['en'][] = "Name"; 
        $this->messages['it'][] = "Nome"; 
        $this->messages['pt'][] = "Nome"; 

        $this->messages['en'][] = "Birth date"; 
        $this->messages['it'][] = "Data di nascita"; 
        $this->messages['pt'][] = "Data de nascimento"; 

        $this->messages['en'][] = "Person Type"; 
        $this->messages['it'][] = "Tipo di persona"; 
        $this->messages['pt'][] = "Tipo de pessoa"; 

        $this->messages['en'][] = "Document"; 
        $this->messages['it'][] = "Documento"; 
        $this->messages['pt'][] = "Documento"; 

        $this->messages['en'][] = "Guid"; 
        $this->messages['it'][] = "Guid"; 
        $this->messages['pt'][] = "Guid"; 

        $this->messages['en'][] = "Mobile number"; 
        $this->messages['it'][] = "Numero di cellulare"; 
        $this->messages['pt'][] = "Celular"; 

        $this->messages['en'][] = "Email"; 
        $this->messages['it'][] = "E-mail"; 
        $this->messages['pt'][] = "E-mail"; 

        $this->messages['en'][] = "Kyc completed"; 
        $this->messages['it'][] = "KYC completato"; 
        $this->messages['pt'][] = "KYX Completado"; 

        $this->messages['en'][] = "Document image"; 
        $this->messages['it'][] = "Immagine del documento"; 
        $this->messages['pt'][] = "Imagem do documento"; 

        $this->messages['en'][] = "User foto"; 
        $this->messages['it'][] = "Foto dell'utente"; 
        $this->messages['pt'][] = "Foto"; 

        $this->messages['en'][] = "Passport foto"; 
        $this->messages['it'][] = "Fototessera"; 
        $this->messages['pt'][] = "Foto do passaporte"; 

        $this->messages['en'][] = "Terms accepted"; 
        $this->messages['it'][] = "Termini accettati"; 
        $this->messages['pt'][] = "Aceite de termos"; 

        $this->messages['en'][] = "Active"; 
        $this->messages['it'][] = "Attiva"; 
        $this->messages['pt'][] = "Ativo"; 

        $this->messages['en'][] = "Permit external access"; 
        $this->messages['it'][] = "Consentire l'accesso esterno"; 
        $this->messages['pt'][] = "Permite acesso externo"; 

        $this->messages['en'][] = "User"; 
        $this->messages['it'][] = "Utente"; 
        $this->messages['pt'][] = "Usuário"; 

        $this->messages['en'][] = "Password"; 
        $this->messages['it'][] = "Password"; 
        $this->messages['pt'][] = "Senha"; 

        $this->messages['en'][] = "Token for 2FA"; 
        $this->messages['it'][] = "Token per 2FA"; 
        $this->messages['pt'][] = "Token para 2FA"; 

        $this->messages['en'][] = "Cell phone for 2FA"; 
        $this->messages['it'][] = "Telefono cellulare per 2FA"; 
        $this->messages['pt'][] = "Celular para 2FA"; 

        $this->messages['en'][] = "E-mail for 2FA"; 
        $this->messages['it'][] = "E-mail per 2FA"; 
        $this->messages['pt'][] = "E-mail para 2FA"; 

        $this->messages['en'][] = "External cliente identification"; 
        $this->messages['it'][] = "Identificazione del cliente esterno"; 
        $this->messages['pt'][] = "Identificação externa"; 

        $this->messages['en'][] = "Linked System User"; 
        $this->messages['it'][] = "Utente del sistema collegato"; 
        $this->messages['pt'][] = "Usuário/Sistema"; 

        $this->messages['en'][] = "Level"; 
        $this->messages['it'][] = "Livello"; 
        $this->messages['pt'][] = "Nível"; 

        $this->messages['en'][] = "Id sync"; 
        $this->messages['it'][] = "Sincronizzazione ID"; 
        $this->messages['pt'][] = "Id de sincronização"; 

        $this->messages['en'][] = "Sex"; 
        $this->messages['it'][] = "Sesso"; 
        $this->messages['pt'][] = "Sexo"; 

        $this->messages['en'][] = "tipo de titular"; 
        $this->messages['it'][] = "tipo de titular"; 
        $this->messages['pt'][] = "tipo de titular"; 

        $this->messages['en'][] = "Coperationtype"; 
        $this->messages['it'][] = "Tipo di operazione"; 
        $this->messages['pt'][] = "Tipo operação"; 

        $this->messages['en'][] = "Nid external"; 
        $this->messages['it'][] = "Nid esterno"; 
        $this->messages['pt'][] = "Id externo"; 

        $this->messages['en'][] = "Shopping/ID"; 
        $this->messages['it'][] = "Shopping/ID"; 
        $this->messages['pt'][] = "Shopping/ID"; 

        $this->messages['en'][] = "External code"; 
        $this->messages['it'][] = "Codice esterno"; 
        $this->messages['pt'][] = "Código externo"; 

        $this->messages['en'][] = "Free/Fee payment"; 
        $this->messages['it'][] = "Pagamento gratuito/a pagamento"; 
        $this->messages['pt'][] = "Taxa para pagamento"; 

        $this->messages['en'][] = "Nlast id location"; 
        $this->messages['it'][] = "Nultima posizione ID"; 
        $this->messages['pt'][] = "Ultimo/Id/Localização"; 

        $this->messages['en'][] = "Ncb"; 
        $this->messages['it'][] = "Ncb"; 
        $this->messages['pt'][] = "Cashback"; 

        $this->messages['en'][] = "Ncbused"; 
        $this->messages['it'][] = "Ncbused"; 
        $this->messages['pt'][] = "Cashback usado"; 

        $this->messages['en'][] = "C2fagoogle secret"; 
        $this->messages['it'][] = "Segreto C2fagoogle"; 
        $this->messages['pt'][] = "Segredo/2FA"; 

        $this->messages['en'][] = "Payment day"; 
        $this->messages['it'][] = "Giorno di pagamento"; 
        $this->messages['pt'][] = "Dia de pagamento"; 

        $this->messages['en'][] = "Nlatitude"; 
        $this->messages['it'][] = "NLatitudine"; 
        $this->messages['pt'][] = "Latitude"; 

        $this->messages['en'][] = "Nlongitude"; 
        $this->messages['it'][] = "NLongitudine"; 
        $this->messages['pt'][] = "Longitude"; 

        $this->messages['en'][] = "Nattempts"; 
        $this->messages['it'][] = "Tentative"; 
        $this->messages['pt'][] = "Parcelas"; 

        $this->messages['en'][] = "Nindications"; 
        $this->messages['it'][] = "NIndicazioni"; 
        $this->messages['pt'][] = "Indicações"; 

        $this->messages['en'][] = "Edit"; 
        $this->messages['it'][] = "Modificare"; 
        $this->messages['pt'][] = "Editar"; 

        $this->messages['en'][] = "Delete"; 
        $this->messages['it'][] = "Eliminare"; 
        $this->messages['pt'][] = "Deletar"; 

        $this->messages['en'][] = "Wallets"; 
        $this->messages['it'][] = "Portafogli"; 
        $this->messages['pt'][] = "Carteiras"; 

        $this->messages['en'][] = "Resetar senha"; 
        $this->messages['it'][] = "Resetar senha"; 
        $this->messages['pt'][] = "Resetar senha"; 

        $this->messages['en'][] = "CSV"; 
        $this->messages['it'][] = "CSV"; 
        $this->messages['pt'][] = "CSV"; 

        $this->messages['en'][] = "XLS"; 
        $this->messages['it'][] = "XLS"; 
        $this->messages['pt'][] = "XLS"; 

        $this->messages['en'][] = "PDF"; 
        $this->messages['it'][] = "PDF"; 
        $this->messages['pt'][] = "PDF"; 

        $this->messages['en'][] = "XML"; 
        $this->messages['it'][] = "XML"; 
        $this->messages['pt'][] = "XML"; 

        $this->messages['en'][] = "Export"; 
        $this->messages['it'][] = "Esportare"; 
        $this->messages['pt'][] = "Exportar"; 

        $this->messages['en'][] = "Name:"; 
        $this->messages['it'][] = "Nome:"; 
        $this->messages['pt'][] = "Nome:"; 

        $this->messages['en'][] = "Document:"; 
        $this->messages['it'][] = "Documento:"; 
        $this->messages['pt'][] = "Documento:"; 

        $this->messages['en'][] = "Person Type:"; 
        $this->messages['it'][] = "Tipo di persona:"; 
        $this->messages['pt'][] = "Tipo de pessoal:"; 

        $this->messages['en'][] = "Active:"; 
        $this->messages['it'][] = "Attiva:"; 
        $this->messages['pt'][] = "Ativo:"; 

        $this->messages['en'][] = "Permit external access:"; 
        $this->messages['it'][] = "Consentire l'accesso esterno:"; 
        $this->messages['pt'][] = "Permitir acesso externo:"; 

        $this->messages['en'][] = "Filter"; 
        $this->messages['it'][] = "Filtro"; 
        $this->messages['pt'][] = "Filtrar"; 

        $this->messages['en'][] = "New"; 
        $this->messages['it'][] = "New"; 
        $this->messages['pt'][] = "Novo"; 

        $this->messages['en'][] = "Commercial (ADM)"; 
        $this->messages['it'][] = "Commerciale (ADM)"; 
        $this->messages['pt'][] = "Comercial (ADM)"; 

        $this->messages['en'][] = "Asset:"; 
        $this->messages['it'][] = "Risorsa:"; 
        $this->messages['pt'][] = "Ativo:"; 

        $this->messages['en'][] = "Price:"; 
        $this->messages['it'][] = "Prezzo:"; 
        $this->messages['pt'][] = "Preço:"; 

        $this->messages['en'][] = "Token amount:"; 
        $this->messages['it'][] = "Importo del token:"; 
        $this->messages['pt'][] = "Quantidade:"; 

        $this->messages['en'][] = "Bonus amount:"; 
        $this->messages['it'][] = "Importo del bonus:"; 
        $this->messages['pt'][] = "Quantidade/Bonus:"; 

        $this->messages['en'][] = "Package Name:"; 
        $this->messages['it'][] = "Nome del pacchetto:"; 
        $this->messages['pt'][] = "Nome do pacote:"; 

        $this->messages['en'][] = "Code:"; 
        $this->messages['it'][] = "Codice:"; 
        $this->messages['pt'][] = "Código:"; 

        $this->messages['en'][] = "Pay fee type:"; 
        $this->messages['it'][] = "Tipo di tariffa di pagamento:"; 
        $this->messages['pt'][] = "Tipo de taxa para pagamento:"; 

        $this->messages['en'][] = "Pay fee value:"; 
        $this->messages['it'][] = "Pay fee value:"; 
        $this->messages['pt'][] = "Valor da taxa:"; 

        $this->messages['en'][] = "Description:"; 
        $this->messages['it'][] = "Descrizione:"; 
        $this->messages['pt'][] = "Descrição:"; 

        $this->messages['en'][] = "Pool:"; 
        $this->messages['it'][] = "Piscina:"; 
        $this->messages['pt'][] = "Piscina:"; 

        $this->messages['en'][] = "Save"; 
        $this->messages['it'][] = "Salva"; 
        $this->messages['pt'][] = "Salvar"; 

        $this->messages['en'][] = "Back"; 
        $this->messages['it'][] = "Indietro"; 
        $this->messages['pt'][] = "Voltar"; 

        $this->messages['en'][] = "Token sale"; 
        $this->messages['it'][] = "Vendita di token"; 
        $this->messages['pt'][] = "Venda de token"; 

        $this->messages['en'][] = "Tbassets id"; 
        $this->messages['it'][] = "Tbassets id"; 
        $this->messages['pt'][] = "Id do ativo"; 

        $this->messages['en'][] = "Token amount"; 
        $this->messages['it'][] = "Importo del token"; 
        $this->messages['pt'][] = "Quantidade"; 

        $this->messages['en'][] = "Code"; 
        $this->messages['it'][] = "Codice"; 
        $this->messages['pt'][] = "Código"; 

        $this->messages['en'][] = "Date"; 
        $this->messages['it'][] = "Data"; 
        $this->messages['pt'][] = "Data"; 

        $this->messages['en'][] = "Idsend"; 
        $this->messages['it'][] = "Idsend"; 
        $this->messages['pt'][] = "Idsend"; 

        $this->messages['en'][] = "Iddest"; 
        $this->messages['it'][] = "Iddest"; 
        $this->messages['pt'][] = "Iddest"; 

        $this->messages['en'][] = "Payer name"; 
        $this->messages['it'][] = "Nome del pagatore"; 
        $this->messages['pt'][] = "Pagador"; 

        $this->messages['en'][] = "Receiver name"; 
        $this->messages['it'][] = "Nome del destinatario"; 
        $this->messages['pt'][] = "Recebedor"; 

        $this->messages['en'][] = "Location Id"; 
        $this->messages['it'][] = "Posizione id"; 
        $this->messages['pt'][] = "Localização"; 

        $this->messages['en'][] = "Net value"; 
        $this->messages['it'][] = "Valore netto"; 
        $this->messages['pt'][] = "Valor liquido"; 

        $this->messages['en'][] = "Start date:"; 
        $this->messages['it'][] = "Data di inizio:"; 
        $this->messages['pt'][] = "Data inicial"; 

        $this->messages['en'][] = "End date:"; 
        $this->messages['it'][] = "Data di fine:"; 
        $this->messages['pt'][] = "Data final"; 

        $this->messages['en'][] = "Cnpj:"; 
        $this->messages['it'][] = "Cnpj:"; 
        $this->messages['pt'][] = "CNPJ:"; 

        $this->messages['en'][] = "Mall:"; 
        $this->messages['it'][] = "Centro commerciale:"; 
        $this->messages['pt'][] = "Shopping:"; 

        $this->messages['en'][] = "View pix"; 
        $this->messages['it'][] = "View pix"; 
        $this->messages['pt'][] = "Ver Pix"; 

        $this->messages['en'][] = "TbViewPix"; 
        $this->messages['it'][] = "TbViewPix"; 
        $this->messages['pt'][] = "Ver pix"; 

        $this->messages['en'][] = "HSM"; 
        $this->messages['it'][] = "HSM"; 
        $this->messages['pt'][] = "HSM"; 

        $this->messages['en'][] = "Blockchain"; 
        $this->messages['it'][] = "Blockchain"; 
        $this->messages['pt'][] = "Blockchain"; 

        $this->messages['en'][] = "Agent"; 
        $this->messages['it'][] = "Agente"; 
        $this->messages['pt'][] = "Agente"; 

        $this->messages['en'][] = "Date time creation"; 
        $this->messages['it'][] = "Data e ora di creazione"; 
        $this->messages['pt'][] = "Data/Hora de criação"; 

        $this->messages['en'][] = "Date time changed"; 
        $this->messages['it'][] = "Data e ora modificate"; 
        $this->messages['pt'][] = "Data/Hora de alteração"; 

        $this->messages['en'][] = "Date time deletion"; 
        $this->messages['it'][] = "Eliminazione data e ora"; 
        $this->messages['pt'][] = "Data/hora de exclusão"; 

        $this->messages['en'][] = "Type"; 
        $this->messages['it'][] = "Tipa"; 
        $this->messages['pt'][] = "Tipo"; 

        $this->messages['en'][] = "Account type"; 
        $this->messages['it'][] = "Tipo di account"; 
        $this->messages['pt'][] = "Tipo de conta"; 

        $this->messages['en'][] = "Publickey"; 
        $this->messages['it'][] = "Chiave pubblica"; 
        $this->messages['pt'][] = "Chave pública"; 

        $this->messages['en'][] = "Chave privada"; 
        $this->messages['it'][] = "Chave privada"; 
        $this->messages['pt'][] = "Chave privada"; 

        $this->messages['en'][] = "PIN"; 
        $this->messages['it'][] = "PIN"; 
        $this->messages['pt'][] = "PIN"; 

        $this->messages['en'][] = "PAN"; 
        $this->messages['it'][] = "PAN"; 
        $this->messages['pt'][] = "PAN"; 

        $this->messages['en'][] = "Serial number"; 
        $this->messages['it'][] = "Numero di serie"; 
        $this->messages['pt'][] = "Número serial"; 

        $this->messages['en'][] = "Smartcard version"; 
        $this->messages['it'][] = "Versione smartcard"; 
        $this->messages['pt'][] = "Versão do Smartcard"; 

        $this->messages['en'][] = "Homologation number"; 
        $this->messages['it'][] = "Numero di omologazione"; 
        $this->messages['pt'][] = "Número de homologação"; 

        $this->messages['en'][] = "Smartcard Key format"; 
        $this->messages['it'][] = "Formato della chiave della smartcard"; 
        $this->messages['pt'][] = "Formato da chave do cartão"; 

        $this->messages['en'][] = "Printer date"; 
        $this->messages['it'][] = "Data della stampante"; 
        $this->messages['pt'][] = "Data de impressão"; 

        $this->messages['en'][] = "Printer partners"; 
        $this->messages['it'][] = "Partner di stampa"; 
        $this->messages['pt'][] = "Parceiro de impressão"; 

        $this->messages['en'][] = "Cpool"; 
        $this->messages['it'][] = "Cpool"; 
        $this->messages['pt'][] = "Piscina:"; 

        $this->messages['en'][] = "Balances"; 
        $this->messages['it'][] = "Saldi"; 
        $this->messages['pt'][] = "Balanços"; 

        $this->messages['en'][] = "Holder:"; 
        $this->messages['it'][] = "Titolare:"; 
        $this->messages['pt'][] = "Titular:"; 

        $this->messages['en'][] = "Type:"; 
        $this->messages['it'][] = "Tipa:"; 
        $this->messages['pt'][] = "Tipo:"; 

        $this->messages['en'][] = "Publickey:"; 
        $this->messages['it'][] = "Chiave pubblica:"; 
        $this->messages['pt'][] = "Chave pública:"; 

        $this->messages['en'][] = "Add"; 
        $this->messages['it'][] = "Aggiungere"; 
        $this->messages['pt'][] = "Novo"; 

        $this->messages['en'][] = "Wallets (adm)"; 
        $this->messages['it'][] = "Portafogli (adm)"; 
        $this->messages['pt'][] = "Carteiras (Adm)"; 

        $this->messages['en'][] = "Wallets (Adm)"; 
        $this->messages['it'][] = "Portafogli (adm)"; 
        $this->messages['pt'][] = "Carteiras (Adm)"; 

        $this->messages['en'][] = "Agent:"; 
        $this->messages['it'][] = "Agente:"; 
        $this->messages['pt'][] = "Agente:"; 

        $this->messages['en'][] = "Event type:"; 
        $this->messages['it'][] = "Tipo di evento:"; 
        $this->messages['pt'][] = "Tipo do evento:"; 

        $this->messages['en'][] = "Date/Time:"; 
        $this->messages['it'][] = "Data/Ora:"; 
        $this->messages['pt'][] = "Data/Hora:"; 

        $this->messages['en'][] = "Memo:"; 
        $this->messages['it'][] = "Promemoria:"; 
        $this->messages['pt'][] = "Memo:"; 

        $this->messages['en'][] = "Acvitivy"; 
        $this->messages['it'][] = "Attività"; 
        $this->messages['pt'][] = "Atividade"; 

        $this->messages['en'][] = "Dbagents id"; 
        $this->messages['it'][] = "ID Dbagents"; 
        $this->messages['pt'][] = "Agente:"; 

        $this->messages['en'][] = "Provider:"; 
        $this->messages['it'][] = "Fornitrice:"; 
        $this->messages['pt'][] = "Provedor:"; 

        $this->messages['en'][] = "End to End:"; 
        $this->messages['it'][] = "End to End:"; 
        $this->messages['pt'][] = "End to End:"; 

        $this->messages['en'][] = "Id:"; 
        $this->messages['it'][] = "Id:"; 
        $this->messages['pt'][] = "Id:"; 

        $this->messages['en'][] = "Value:"; 
        $this->messages['it'][] = "Valore:"; 
        $this->messages['pt'][] = "Valor:"; 

        $this->messages['en'][] = "Net value:"; 
        $this->messages['it'][] = "Valore netto:"; 
        $this->messages['pt'][] = "Valor líquido:"; 

        $this->messages['en'][] = "Bank/Id:"; 
        $this->messages['it'][] = "Banca/ID:"; 
        $this->messages['pt'][] = "Id no banco parceiro:"; 

        $this->messages['en'][] = "Status:"; 
        $this->messages['it'][] = "Stato:"; 
        $this->messages['pt'][] = "Situação:"; 

        $this->messages['en'][] = "QRCode:"; 
        $this->messages['it'][] = "Codice QR:"; 
        $this->messages['pt'][] = "QRCode:"; 

        $this->messages['en'][] = "Id/Reversal:"; 
        $this->messages['it'][] = "Id/Inversione:"; 
        $this->messages['pt'][] = "Id de reversão"; 

        $this->messages['en'][] = "Revertion:"; 
        $this->messages['it'][] = "Reversione:"; 
        $this->messages['pt'][] = "Reversão"; 

        $this->messages['en'][] = "Key/Type:"; 
        $this->messages['it'][] = "Chiave/Tipo:"; 
        $this->messages['pt'][] = "Tipo/Chave:"; 

        $this->messages['en'][] = "Destination key:"; 
        $this->messages['it'][] = "Chiave di destinazione:"; 
        $this->messages['pt'][] = "Chave destino:"; 

        $this->messages['en'][] = "Id/Key:"; 
        $this->messages['it'][] = "ID/Chiave:"; 
        $this->messages['pt'][] = "Id/Chave:"; 

        $this->messages['en'][] = "Fee:"; 
        $this->messages['it'][] = "Tassa:"; 
        $this->messages['pt'][] = "Taxa:"; 

        $this->messages['en'][] = "Observation:"; 
        $this->messages['it'][] = "Osservazione:"; 
        $this->messages['pt'][] = "Observação1:"; 

        $this->messages['en'][] = "End to End reversion:"; 
        $this->messages['it'][] = "Reversione end-to-end:"; 
        $this->messages['pt'][] = "End to End da reversão:"; 

        $this->messages['en'][] = "Reason revertion:"; 
        $this->messages['it'][] = "Motivo del ripristino:"; 
        $this->messages['pt'][] = "Razão da reversão:"; 

        $this->messages['en'][] = "Refunds:"; 
        $this->messages['it'][] = "Rimborsi:"; 
        $this->messages['pt'][] = "Devoluções:"; 

        $this->messages['en'][] = "Balance processed"; 
        $this->messages['it'][] = "Saldo elaborato"; 
        $this->messages['pt'][] = "Balanço processado:"; 

        $this->messages['en'][] = "Source"; 
        $this->messages['it'][] = "Fonte"; 
        $this->messages['pt'][] = "Origem"; 

        $this->messages['en'][] = "Source bank:"; 
        $this->messages['it'][] = "Banca di origine:"; 
        $this->messages['pt'][] = "Banco de origem:"; 

        $this->messages['en'][] = "ISPB:"; 
        $this->messages['it'][] = "ISPB:"; 
        $this->messages['pt'][] = "ISPB:"; 

        $this->messages['en'][] = "Source agency:"; 
        $this->messages['it'][] = "Agenzia di provenienza:"; 
        $this->messages['pt'][] = "Agência de origem:"; 

        $this->messages['en'][] = "Source account:"; 
        $this->messages['it'][] = "Fonte dell'account:"; 
        $this->messages['pt'][] = "Conta de origem:"; 

        $this->messages['en'][] = "Source name:"; 
        $this->messages['it'][] = "Nome della fonte:"; 
        $this->messages['pt'][] = "Nome:"; 

        $this->messages['en'][] = "Source document:"; 
        $this->messages['it'][] = "Documento di origine:"; 
        $this->messages['pt'][] = "CPF:"; 

        $this->messages['en'][] = "Destination"; 
        $this->messages['it'][] = "Destinazione"; 
        $this->messages['pt'][] = "Destino:"; 

        $this->messages['en'][] = "Destination bank:"; 
        $this->messages['it'][] = "Banca di destinazione:"; 
        $this->messages['pt'][] = "Banco de destino:"; 

        $this->messages['en'][] = "Destination agency:"; 
        $this->messages['it'][] = "Agenzia di destinazione:"; 
        $this->messages['pt'][] = "Agência de destino:"; 

        $this->messages['en'][] = "Destination account:"; 
        $this->messages['it'][] = "Conto di destinazione:"; 
        $this->messages['pt'][] = "Conta de destino:"; 

        $this->messages['en'][] = "Destination name:"; 
        $this->messages['it'][] = "Nome della destinazione:"; 
        $this->messages['pt'][] = "Nome do destinatário:"; 

        $this->messages['en'][] = "Destination document:"; 
        $this->messages['it'][] = "Documento di destinazione:"; 
        $this->messages['pt'][] = "Documento do destinatário:"; 

        $this->messages['en'][] = "Internal Sender:"; 
        $this->messages['it'][] = "Mittente interno:"; 
        $this->messages['pt'][] = "Remetente interno:"; 

        $this->messages['en'][] = "Internal recipient:"; 
        $this->messages['it'][] = "Destinatario interno:"; 
        $this->messages['pt'][] = "Destinatário interno:"; 

        $this->messages['en'][] = "Webhook:"; 
        $this->messages['it'][] = "Webhook:"; 
        $this->messages['pt'][] = "Webhook:"; 

        $this->messages['en'][] = "Notified:"; 
        $this->messages['it'][] = "Notificato:"; 
        $this->messages['pt'][] = "Notificado:"; 

        $this->messages['en'][] = "Number of notifications:"; 
        $this->messages['it'][] = "Numero di notifiche:"; 
        $this->messages['pt'][] = "Número de notificações:"; 

        $this->messages['en'][] = "Notification result:"; 
        $this->messages['it'][] = "Risultato della notifica:"; 
        $this->messages['pt'][] = "Resultado da notificação:"; 

        $this->messages['en'][] = "PIX"; 
        $this->messages['it'][] = "PIX"; 
        $this->messages['pt'][] = "PIX"; 

        $this->messages['en'][] = "Informations"; 
        $this->messages['it'][] = "Informazioni"; 
        $this->messages['pt'][] = "Informações"; 

        $this->messages['en'][] = "Agents"; 
        $this->messages['it'][] = "Agenti"; 
        $this->messages['pt'][] = "Agentes"; 

        $this->messages['en'][] = "Webhook"; 
        $this->messages['it'][] = "Webhook"; 
        $this->messages['pt'][] = "Webhook"; 

        $this->messages['en'][] = "HSM:"; 
        $this->messages['it'][] = "HSM:"; 
        $this->messages['pt'][] = "HSM:"; 

        $this->messages['en'][] = "Blockchain:"; 
        $this->messages['it'][] = "Blockchain:"; 
        $this->messages['pt'][] = "Blockchain:"; 

        $this->messages['en'][] = "Account type:"; 
        $this->messages['it'][] = "Tipo di account:"; 
        $this->messages['pt'][] = "Tipo de conta:"; 

        $this->messages['en'][] = "Publick key:"; 
        $this->messages['it'][] = "Chiave pubblica:"; 
        $this->messages['pt'][] = "Chave pública:"; 

        $this->messages['en'][] = "Password:"; 
        $this->messages['it'][] = "Password:"; 
        $this->messages['pt'][] = "Senha:"; 

        $this->messages['en'][] = "PIN:"; 
        $this->messages['it'][] = "PIN:"; 
        $this->messages['pt'][] = "PIN:"; 

        $this->messages['en'][] = "PAN:"; 
        $this->messages['it'][] = "PAN:"; 
        $this->messages['pt'][] = "PAN:"; 

        $this->messages['en'][] = "Serial number:"; 
        $this->messages['it'][] = "Numero di serie:"; 
        $this->messages['pt'][] = "Número serial:"; 

        $this->messages['en'][] = "Smartcard version:"; 
        $this->messages['it'][] = "Versione della smartcard:"; 
        $this->messages['pt'][] = "Versão do Smartcard:"; 

        $this->messages['en'][] = "Printer partners:"; 
        $this->messages['it'][] = "Partner di stampa:"; 
        $this->messages['pt'][] = "Parceiros de impressão:"; 

        $this->messages['en'][] = "Printer date:"; 
        $this->messages['it'][] = "Data di stampa:"; 
        $this->messages['pt'][] = "Data da impressão:"; 

        $this->messages['en'][] = "Homologation number:"; 
        $this->messages['it'][] = "Numero di omologazione:"; 
        $this->messages['pt'][] = "Número de homologação:"; 

        $this->messages['en'][] = "Smartcard Key format:"; 
        $this->messages['it'][] = "Formato della chiave della smartcard:"; 
        $this->messages['pt'][] = "Formato da chave do Smartcard:"; 

        $this->messages['en'][] = "General data"; 
        $this->messages['it'][] = "Dati generali"; 
        $this->messages['pt'][] = "Dados gerais"; 

        $this->messages['en'][] = "Smartcard"; 
        $this->messages['it'][] = "Smartcard"; 
        $this->messages['pt'][] = "Smartcard"; 

        $this->messages['en'][] = "Birth date:"; 
        $this->messages['it'][] = "Data di nascita:"; 
        $this->messages['pt'][] = "Nascimento:"; 

        $this->messages['en'][] = "Document type:"; 
        $this->messages['it'][] = "Tipo di documento:"; 
        $this->messages['pt'][] = "Tipo do documento:"; 

        $this->messages['en'][] = "Sex:"; 
        $this->messages['it'][] = "Sesso"; 
        $this->messages['pt'][] = "Sexo:"; 

        $this->messages['en'][] = "Mobile number:"; 
        $this->messages['it'][] = "Numero di cellulare:"; 
        $this->messages['pt'][] = "Celular:"; 

        $this->messages['en'][] = "Email:"; 
        $this->messages['it'][] = "Email:"; 
        $this->messages['pt'][] = "E-mail:"; 

        $this->messages['en'][] = "Kyc completed:"; 
        $this->messages['it'][] = "KYC completato:"; 
        $this->messages['pt'][] = "KYX Concluído:"; 

        $this->messages['en'][] = "Terms accepted:"; 
        $this->messages['it'][] = "Termini accettati:"; 
        $this->messages['pt'][] = "Aceitou os termos:"; 

        $this->messages['en'][] = "Document image:"; 
        $this->messages['it'][] = "Immagine del documento:"; 
        $this->messages['pt'][] = "Imagem do documento:"; 

        $this->messages['en'][] = "User foto:"; 
        $this->messages['it'][] = "Foto dell'utente:"; 
        $this->messages['pt'][] = "Foto do usuário"; 

        $this->messages['en'][] = "Passport foto:"; 
        $this->messages['it'][] = "Fototessera:"; 
        $this->messages['pt'][] = "Foto do passaporte:"; 

        $this->messages['en'][] = "User:"; 
        $this->messages['it'][] = "Utente:"; 
        $this->messages['pt'][] = "Usuário:"; 

        $this->messages['en'][] = "Cell phone for 2FA:"; 
        $this->messages['it'][] = "Cellulare per 2FA:"; 
        $this->messages['pt'][] = "Celulara para 2FA:"; 

        $this->messages['en'][] = "E-mail for 2FA:"; 
        $this->messages['it'][] = "E-mail per 2FA:"; 
        $this->messages['pt'][] = "E-mail para 2FA:"; 

        $this->messages['en'][] = "Token for 2FA:"; 
        $this->messages['it'][] = "Token per 2FA:"; 
        $this->messages['pt'][] = "Token para 2FA:"; 

        $this->messages['en'][] = "New address"; 
        $this->messages['it'][] = "Nuovo indirizzo"; 
        $this->messages['pt'][] = "Novo endereço"; 

        $this->messages['en'][] = "Address"; 
        $this->messages['it'][] = "Indirizzo"; 
        $this->messages['pt'][] = "Endereço"; 

        $this->messages['en'][] = "Address type:"; 
        $this->messages['it'][] = "Tipo di indirizzo:"; 
        $this->messages['pt'][] = "Tipo de endereço:"; 

        $this->messages['en'][] = "Zip code:"; 
        $this->messages['it'][] = "Cap:"; 
        $this->messages['pt'][] = "CEP:"; 

        $this->messages['en'][] = "State:"; 
        $this->messages['it'][] = "Stato:"; 
        $this->messages['pt'][] = "Estado:"; 

        $this->messages['en'][] = "City:"; 
        $this->messages['it'][] = "Città:"; 
        $this->messages['pt'][] = "Cidade:"; 

        $this->messages['en'][] = "Address:"; 
        $this->messages['it'][] = "Indirizzo:"; 
        $this->messages['pt'][] = "Endereço:"; 

        $this->messages['en'][] = "Number:"; 
        $this->messages['it'][] = "Numero:"; 
        $this->messages['pt'][] = "Número:"; 

        $this->messages['en'][] = "Complement:"; 
        $this->messages['it'][] = "Complemento:"; 
        $this->messages['pt'][] = "Complemento:"; 

        $this->messages['en'][] = "Neighborhood:"; 
        $this->messages['it'][] = "Quartiere:"; 
        $this->messages['pt'][] = "Bairro"; 

        $this->messages['en'][] = "Address type"; 
        $this->messages['it'][] = "Tipo di indirizzo"; 
        $this->messages['pt'][] = "Tipo de endereço"; 

        $this->messages['en'][] = "Zip code"; 
        $this->messages['it'][] = "Cap"; 
        $this->messages['pt'][] = "CEP"; 

        $this->messages['en'][] = "State"; 
        $this->messages['it'][] = "Stato"; 
        $this->messages['pt'][] = "Estado"; 

        $this->messages['en'][] = "City"; 
        $this->messages['it'][] = "Città"; 
        $this->messages['pt'][] = "Cidade"; 

        $this->messages['en'][] = "Executive Board"; 
        $this->messages['it'][] = "Consiglio di amministrazione"; 
        $this->messages['pt'][] = "Diretoria"; 

        $this->messages['en'][] = "CPF / CNPJ"; 
        $this->messages['it'][] = "CPF / CNPJ"; 
        $this->messages['pt'][] = "CPF/Cnpj"; 

        $this->messages['en'][] = "KYC"; 
        $this->messages['it'][] = "KYC"; 
        $this->messages['pt'][] = "KYC"; 

        $this->messages['en'][] = "2FA"; 
        $this->messages['it'][] = "2FA"; 
        $this->messages['pt'][] = "2FA"; 

        $this->messages['en'][] = "Allowed IPs:"; 
        $this->messages['it'][] = "IP consentiti:"; 
        $this->messages['pt'][] = "IPs permitidos:"; 

        $this->messages['en'][] = "Accesss:"; 
        $this->messages['it'][] = "Accesso:"; 
        $this->messages['pt'][] = "Acesso:"; 

        $this->messages['en'][] = "API Access"; 
        $this->messages['it'][] = "Accesso API"; 
        $this->messages['pt'][] = "Acesso a API:"; 

        $this->messages['en'][] = "Allowed IPs"; 
        $this->messages['it'][] = "IP consentiti"; 
        $this->messages['pt'][] = "Ips permitidos"; 

        $this->messages['en'][] = "Access"; 
        $this->messages['it'][] = "Accesso"; 
        $this->messages['pt'][] = "Acesso"; 

        $this->messages['en'][] = "Wallet:"; 
        $this->messages['it'][] = "Portafoglio:"; 
        $this->messages['pt'][] = "Carteira:"; 

        $this->messages['en'][] = "From:"; 
        $this->messages['it'][] = "Da:"; 
        $this->messages['pt'][] = "De:"; 

        $this->messages['en'][] = "Quantity:"; 
        $this->messages['it'][] = "Quantità:"; 
        $this->messages['pt'][] = "Quantidade"; 

        $this->messages['en'][] = "Destination:"; 
        $this->messages['it'][] = "Destinazione:"; 
        $this->messages['pt'][] = "Destino:"; 

        $this->messages['en'][] = "Select Wallet:"; 
        $this->messages['it'][] = "Seleziona Portafoglio:"; 
        $this->messages['pt'][] = "Selecione a Wallet:"; 

        $this->messages['en'][] = "To:"; 
        $this->messages['it'][] = "A:"; 
        $this->messages['pt'][] = "Para:"; 

        $this->messages['en'][] = "Public key:"; 
        $this->messages['it'][] = "Chiave pubblica:"; 
        $this->messages['pt'][] = "Chave pública:"; 

        $this->messages['en'][] = "Internal Id:"; 
        $this->messages['it'][] = "ID interno:"; 
        $this->messages['pt'][] = "Id interno:"; 

        $this->messages['en'][] = "Canceled:"; 
        $this->messages['it'][] = "Annullata:"; 
        $this->messages['pt'][] = "Cancelado:"; 

        $this->messages['en'][] = "Reason cancelation:"; 
        $this->messages['it'][] = "Motivo annullamento:"; 
        $this->messages['pt'][] = "Razão do cancelamento:"; 

        $this->messages['en'][] = "Deadline for GAS Subsidy"; 
        $this->messages['it'][] = "Scadenza per il sussidio GAS"; 
        $this->messages['pt'][] = "Linha final do subsídio (Data/Segundos)"; 

        $this->messages['en'][] = "Deadline:"; 
        $this->messages['it'][] = "Scadenza:"; 
        $this->messages['pt'][] = "Linha final para o subsídio"; 

        $this->messages['en'][] = "R:"; 
        $this->messages['it'][] = "R:"; 
        $this->messages['pt'][] = "R:"; 

        $this->messages['en'][] = "S:"; 
        $this->messages['it'][] = "S:"; 
        $this->messages['pt'][] = "S:"; 

        $this->messages['en'][] = "V:"; 
        $this->messages['it'][] = "V:"; 
        $this->messages['pt'][] = "V:"; 

        $this->messages['en'][] = "Approvals (Adm)"; 
        $this->messages['it'][] = "Approvazioni (Adm)"; 
        $this->messages['pt'][] = "Aprovações (Adm)"; 

        $this->messages['en'][] = "Holder"; 
        $this->messages['it'][] = "Titolare"; 
        $this->messages['pt'][] = "Titular"; 

        $this->messages['en'][] = "Asset"; 
        $this->messages['it'][] = "Risorsa"; 
        $this->messages['pt'][] = "Ativo"; 

        $this->messages['en'][] = "Wallet from"; 
        $this->messages['it'][] = "Portafoglio da"; 
        $this->messages['pt'][] = "Carteira de envio"; 

        $this->messages['en'][] = "Transfer"; 
        $this->messages['it'][] = "Trasferire"; 
        $this->messages['pt'][] = "Transferência"; 

        $this->messages['en'][] = "Whitelist"; 
        $this->messages['it'][] = "Lista bianca"; 
        $this->messages['pt'][] = "Whitelist"; 

        $this->messages['en'][] = "Custodial wallets"; 
        $this->messages['it'][] = "Portafogli custodiali"; 
        $this->messages['pt'][] = "Carteiras custodiadas"; 

        $this->messages['en'][] = "Status"; 
        $this->messages['it'][] = "Stato"; 
        $this->messages['pt'][] = "Situação"; 

        $this->messages['en'][] = "Date/Time creation"; 
        $this->messages['it'][] = "Data/Ora di creazione"; 
        $this->messages['pt'][] = "Data/Hora de criação"; 

        $this->messages['en'][] = "Ddhchanged"; 
        $this->messages['it'][] = "Ddhchanged"; 
        $this->messages['pt'][] = "Alteração"; 

        $this->messages['en'][] = "Cprovider"; 
        $this->messages['it'][] = "Fornitore di servizi"; 
        $this->messages['pt'][] = "Provedor"; 

        $this->messages['en'][] = "Ddatetime"; 
        $this->messages['it'][] = "Data/ora"; 
        $this->messages['pt'][] = "Data/Hora"; 

        $this->messages['en'][] = "Value"; 
        $this->messages['it'][] = "Valore"; 
        $this->messages['pt'][] = "Valor"; 

        $this->messages['en'][] = "Cdescription"; 
        $this->messages['it'][] = "Descrizione"; 
        $this->messages['pt'][] = "Descrição"; 

        $this->messages['en'][] = "Cbankid"; 
        $this->messages['it'][] = "bankid"; 
        $this->messages['pt'][] = "Banco/Id"; 

        $this->messages['en'][] = "Csignature"; 
        $this->messages['it'][] = "Firma"; 
        $this->messages['pt'][] = "Assinatura"; 

        $this->messages['en'][] = "Cidreversal"; 
        $this->messages['it'][] = "Idinversione"; 
        $this->messages['pt'][] = "Id de reversão"; 

        $this->messages['en'][] = "Creversao"; 
        $this->messages['it'][] = "Inversione"; 
        $this->messages['pt'][] = "Reversão"; 

        $this->messages['en'][] = "Creasonreversal"; 
        $this->messages['it'][] = "Ragione inversione"; 
        $this->messages['pt'][] = "Razão da reversão"; 

        $this->messages['en'][] = "Cqrcode"; 
        $this->messages['it'][] = "Codice QR"; 
        $this->messages['pt'][] = "QRCode"; 

        $this->messages['en'][] = "Ckeytype"; 
        $this->messages['it'][] = "Tipo di chiave"; 
        $this->messages['pt'][] = "Tipo"; 

        $this->messages['en'][] = "Cdestkey"; 
        $this->messages['it'][] = "Tasto del desktop"; 
        $this->messages['pt'][] = "Chave destino"; 

        $this->messages['en'][] = "Cdestname"; 
        $this->messages['it'][] = "Nomedestinazione"; 
        $this->messages['pt'][] = "Nome do estino"; 

        $this->messages['en'][] = "Cdestdoc"; 
        $this->messages['it'][] = "Cdestdoc"; 
        $this->messages['pt'][] = "Documento de destino"; 

        $this->messages['en'][] = "Cdestagency"; 
        $this->messages['it'][] = "Cdestagionalizzazione"; 
        $this->messages['pt'][] = "Agância de destino"; 

        $this->messages['en'][] = "Cdestaccount"; 
        $this->messages['it'][] = "Cconto discendente"; 
        $this->messages['pt'][] = "Conta de destino"; 

        $this->messages['en'][] = "Cdestbank"; 
        $this->messages['it'][] = "Cbanca di desti"; 
        $this->messages['pt'][] = "Banco de destino"; 

        $this->messages['en'][] = "Corigname"; 
        $this->messages['it'][] = "Cnome d'origine"; 
        $this->messages['pt'][] = "Nome/Origem"; 

        $this->messages['en'][] = "Corigdoc"; 
        $this->messages['it'][] = "Corigdoc"; 
        $this->messages['pt'][] = "Doc/Origem"; 

        $this->messages['en'][] = "Corigagency"; 
        $this->messages['it'][] = "Cagenzia di origine"; 
        $this->messages['pt'][] = "Agência"; 

        $this->messages['en'][] = "Corigaccount"; 
        $this->messages['it'][] = "Cconto originale"; 
        $this->messages['pt'][] = "Conta"; 

        $this->messages['en'][] = "Corigbank"; 
        $this->messages['it'][] = "Cbanca dati originale"; 
        $this->messages['pt'][] = "Banci"; 

        $this->messages['en'][] = "Cidkey"; 
        $this->messages['it'][] = "Cidkey"; 
        $this->messages['pt'][] = "Id/Chaver"; 

        $this->messages['en'][] = "Cwebhook"; 
        $this->messages['it'][] = "Cwebhook"; 
        $this->messages['pt'][] = "Webhook"; 

        $this->messages['en'][] = "Cnotified"; 
        $this->messages['it'][] = "Cnotificato"; 
        $this->messages['pt'][] = "Noitificado"; 

        $this->messages['en'][] = "Nfee"; 
        $this->messages['it'][] = "Ntassa"; 
        $this->messages['pt'][] = "Taxa"; 

        $this->messages['en'][] = "Nnotifications"; 
        $this->messages['it'][] = "Nnotifiche"; 
        $this->messages['pt'][] = "Notificações"; 

        $this->messages['en'][] = "Cresult"; 
        $this->messages['it'][] = "Crisultato"; 
        $this->messages['pt'][] = "Resultado"; 

        $this->messages['en'][] = "Cobservation"; 
        $this->messages['it'][] = "Cosservazione"; 
        $this->messages['pt'][] = "Observação"; 

        $this->messages['en'][] = "ETOE"; 
        $this->messages['it'][] = "ETOE"; 
        $this->messages['pt'][] = "End to End"; 

        $this->messages['en'][] = "Cetoerev"; 
        $this->messages['it'][] = "Cetoerev"; 
        $this->messages['pt'][] = "End to End da reversão"; 

        $this->messages['en'][] = "Cprocbalance"; 
        $this->messages['it'][] = "Cequilibrio propulsivo"; 
        $this->messages['pt'][] = "Processou saldo"; 

        $this->messages['en'][] = "Crefunds"; 
        $this->messages['it'][] = "Crimborsi"; 
        $this->messages['pt'][] = "Devoluções"; 

        $this->messages['en'][] = "Cjson"; 
        $this->messages['it'][] = "Cjson"; 
        $this->messages['pt'][] = "JSon"; 

        $this->messages['en'][] = "Tbagents id"; 
        $this->messages['it'][] = "Tbagents id"; 
        $this->messages['pt'][] = "Agentes"; 

        $this->messages['en'][] = "Tborderpayment id"; 
        $this->messages['it'][] = "Tborderpayment id"; 
        $this->messages['pt'][] = "Pedido"; 

        $this->messages['en'][] = "Tborder id"; 
        $this->messages['it'][] = "Tborder id"; 
        $this->messages['pt'][] = "Id do pedido"; 

        $this->messages['en'][] = "Tbholders id dest"; 
        $this->messages['it'][] = "Tbholders id dest"; 
        $this->messages['pt'][] = "Destino"; 

        $this->messages['en'][] = "ISPB"; 
        $this->messages['it'][] = "ISPB"; 
        $this->messages['pt'][] = "ISPB"; 

        $this->messages['en'][] = "Corigispb"; 
        $this->messages['it'][] = "Corigispb"; 
        $this->messages['pt'][] = "ISPB origem"; 

        $this->messages['en'][] = "Founding date:"; 
        $this->messages['it'][] = "Data di fondazione:"; 
        $this->messages['pt'][] = "Data de fundação:"; 

        $this->messages['en'][] = "Treasury Reserve"; 
        $this->messages['it'][] = "Riserva del Tesoro"; 
        $this->messages['pt'][] = "Tesouraria reserva"; 

        $this->messages['en'][] = "Data/Time creation"; 
        $this->messages['it'][] = "Creazione di dati/ora"; 
        $this->messages['pt'][] = "Data/Hora da criação"; 

        $this->messages['en'][] = "Date/Hour changed"; 
        $this->messages['it'][] = "Data/Ora modificata"; 
        $this->messages['pt'][] = "Data/Hora da alteração"; 

        $this->messages['en'][] = "date/time deletion"; 
        $this->messages['it'][] = "cancellazione data/ora"; 
        $this->messages['pt'][] = "Data/Hora da exclusão"; 

        $this->messages['en'][] = "User/Create"; 
        $this->messages['it'][] = "Utente/Crea"; 
        $this->messages['pt'][] = "Usuário/Criação"; 

        $this->messages['en'][] = "User/Change"; 
        $this->messages['it'][] = "Utente/Modifica"; 
        $this->messages['pt'][] = "Usuário/Alteração"; 

        $this->messages['en'][] = "User/Deletion"; 
        $this->messages['it'][] = "Utente/Eliminazione"; 
        $this->messages['pt'][] = "Usuário/Exclusão"; 

        $this->messages['en'][] = "Date/Time"; 
        $this->messages['it'][] = "Data/Ora"; 
        $this->messages['pt'][] = "Data/Hora"; 

        $this->messages['en'][] = "Event type"; 
        $this->messages['it'][] = "Tipo di evento"; 
        $this->messages['pt'][] = "Tipo do evento"; 

        $this->messages['en'][] = "Memo"; 
        $this->messages['it'][] = "Promemoria"; 
        $this->messages['pt'][] = "Memo"; 

        $this->messages['en'][] = "Ip"; 
        $this->messages['it'][] = "Ip"; 
        $this->messages['pt'][] = "Ip"; 

        $this->messages['en'][] = "Use shamir/M/N"; 
        $this->messages['it'][] = "Usa shamir/M/N"; 
        $this->messages['pt'][] = "Usa Shamir/MdeN"; 

        $this->messages['en'][] = "HSM Model"; 
        $this->messages['it'][] = "Modello HSM"; 
        $this->messages['pt'][] = "Modelo do HSM"; 

        $this->messages['en'][] = "Port"; 
        $this->messages['it'][] = "Porta"; 
        $this->messages['pt'][] = "Porta"; 

        $this->messages['en'][] = "Master key name"; 
        $this->messages['it'][] = "Nome della chiave principale"; 
        $this->messages['pt'][] = "Nome da Master Key"; 

        $this->messages['en'][] = "User name"; 
        $this->messages['it'][] = "Nome utente"; 
        $this->messages['pt'][] = "Nome do usuário"; 

        $this->messages['en'][] = "Smartcard information"; 
        $this->messages['it'][] = "Informazioni sulla smartcard"; 
        $this->messages['pt'][] = "Informação do Smartcard"; 

        $this->messages['en'][] = "Wallets view"; 
        $this->messages['it'][] = "Visualizzazione Portafogli"; 
        $this->messages['pt'][] = "Ver carteiras"; 

        $this->messages['en'][] = "Dbhsm id"; 
        $this->messages['it'][] = "ID DBHSM"; 
        $this->messages['pt'][] = "HSM"; 

        $this->messages['en'][] = "Dbblockchains id"; 
        $this->messages['it'][] = "ID Dbblockchains"; 
        $this->messages['pt'][] = "Blockchain"; 

        $this->messages['en'][] = "Ddhcreation"; 
        $this->messages['it'][] = "Ddhcreazione"; 
        $this->messages['pt'][] = "Criação"; 

        $this->messages['en'][] = "Public key"; 
        $this->messages['it'][] = "Chiave pubblica"; 
        $this->messages['pt'][] = "Chave pública"; 

        $this->messages['en'][] = "Agent Wallets"; 
        $this->messages['it'][] = "Portafogli dell'agente"; 
        $this->messages['pt'][] = "Carteiras de agentes"; 

        $this->messages['en'][] = "Order:"; 
        $this->messages['it'][] = "Ordine:"; 
        $this->messages['pt'][] = "Pedido:"; 

        $this->messages['en'][] = "Amount:"; 
        $this->messages['it'][] = "Quantità:"; 
        $this->messages['pt'][] = "Quantidade:"; 

        $this->messages['en'][] = "Total:"; 
        $this->messages['it'][] = "Totale:"; 
        $this->messages['pt'][] = "Total:"; 

        $this->messages['en'][] = "Process/Transfer:"; 
        $this->messages['it'][] = "Processo/Trasferimento:"; 
        $this->messages['pt'][] = "Processado:"; 

        $this->messages['en'][] = "Order itens"; 
        $this->messages['it'][] = "Ordina gli articoli"; 
        $this->messages['pt'][] = "Itens"; 

        $this->messages['en'][] = "Dborder id"; 
        $this->messages['it'][] = "Dborder id"; 
        $this->messages['pt'][] = "Pedido"; 

        $this->messages['en'][] = "Dbassets id"; 
        $this->messages['it'][] = "ID Dbassets"; 
        $this->messages['pt'][] = "Ativo"; 

        $this->messages['en'][] = "Hash:"; 
        $this->messages['it'][] = "Hash:"; 
        $this->messages['pt'][] = "Hash:"; 

        $this->messages['en'][] = "Block Number:"; 
        $this->messages['it'][] = "Numero di blocco:"; 
        $this->messages['pt'][] = "Número do bloco:"; 

        $this->messages['en'][] = "Crawler"; 
        $this->messages['it'][] = "Crawler"; 
        $this->messages['pt'][] = "Buscador"; 

        $this->messages['en'][] = "Data/Time creation:"; 
        $this->messages['it'][] = "Creazione di dati/ora:"; 
        $this->messages['pt'][] = "Cata/Hora de criação:"; 

        $this->messages['en'][] = "Type payment:"; 
        $this->messages['it'][] = "Tipo pagamento:"; 
        $this->messages['pt'][] = "Tipo de pagamento:"; 

        $this->messages['en'][] = "Method:"; 
        $this->messages['it'][] = "Metodo:"; 
        $this->messages['pt'][] = "Método:"; 

        $this->messages['en'][] = "Available date:"; 
        $this->messages['it'][] = "Data disponibile:"; 
        $this->messages['pt'][] = "Data de disponibilidade:"; 

        $this->messages['en'][] = "Available value:"; 
        $this->messages['it'][] = "Valore disponibile:"; 
        $this->messages['pt'][] = "Valor disponível:"; 

        $this->messages['en'][] = "Gross amount:"; 
        $this->messages['it'][] = "Importo lordo:"; 
        $this->messages['pt'][] = "Valor bruto:"; 

        $this->messages['en'][] = "Extra amount:"; 
        $this->messages['it'][] = "Importo aggiuntivo:"; 
        $this->messages['pt'][] = "Valor/Extras:"; 

        $this->messages['en'][] = "Installments:"; 
        $this->messages['it'][] = "Rate:"; 
        $this->messages['pt'][] = "Parcelas:"; 

        $this->messages['en'][] = "Installment value:"; 
        $this->messages['it'][] = "Valore della rata:"; 
        $this->messages['pt'][] = "Valor da parcela:"; 

        $this->messages['en'][] = "TEF Type:"; 
        $this->messages['it'][] = "Tipo TEF:"; 
        $this->messages['pt'][] = "Tipo do TEF:"; 

        $this->messages['en'][] = "NSU:"; 
        $this->messages['it'][] = "NSU:"; 
        $this->messages['pt'][] = "NSU:"; 

        $this->messages['en'][] = "Autorizathion:"; 
        $this->messages['it'][] = "Autorizzazione:"; 
        $this->messages['pt'][] = "Autorização:"; 

        $this->messages['en'][] = "Type/Id:"; 
        $this->messages['it'][] = "Tipo/ID:"; 
        $this->messages['pt'][] = "Tipo/Id:"; 

        $this->messages['en'][] = "Establishment:"; 
        $this->messages['it'][] = "Istituzione:"; 
        $this->messages['pt'][] = "Estabelecimento:"; 

        $this->messages['en'][] = "Acquire:"; 
        $this->messages['it'][] = "Acquisire:"; 
        $this->messages['pt'][] = "Adquirente:"; 

        $this->messages['en'][] = "E-mail:"; 
        $this->messages['it'][] = "E-mail:"; 
        $this->messages['pt'][] = "E-mail:"; 

        $this->messages['en'][] = "Cell phone:"; 
        $this->messages['it'][] = "Cellulare:"; 
        $this->messages['pt'][] = "Celular:"; 

        $this->messages['en'][] = "Document number:"; 
        $this->messages['it'][] = "Numero del documento:"; 
        $this->messages['pt'][] = "Número do documento:"; 

        $this->messages['en'][] = "Date/Time pix:"; 
        $this->messages['it'][] = "Data/Ora pix:"; 
        $this->messages['pt'][] = "Data/Hora do Pix:"; 

        $this->messages['en'][] = "Pix holder:"; 
        $this->messages['it'][] = "titolare Pix:"; 
        $this->messages['pt'][] = "Proprietário do Pix:"; 

        $this->messages['en'][] = "Pix type:"; 
        $this->messages['it'][] = "tipo Pix:"; 
        $this->messages['pt'][] = "Tipo:"; 

        $this->messages['en'][] = "Bank name:"; 
        $this->messages['it'][] = "Nome della banca:"; 
        $this->messages['pt'][] = "Banco:"; 

        $this->messages['en'][] = "Agency:"; 
        $this->messages['it'][] = "Agenzia:"; 
        $this->messages['pt'][] = "Agência:"; 

        $this->messages['en'][] = "Account:"; 
        $this->messages['it'][] = "Account:"; 
        $this->messages['pt'][] = "Conta:"; 

        $this->messages['en'][] = "Card number (PAN):"; 
        $this->messages['it'][] = "Numero della carta (PAN):"; 
        $this->messages['pt'][] = "Número do cartão (PAN):"; 

        $this->messages['en'][] = "Preço:"; 
        $this->messages['it'][] = "Prezzo:"; 
        $this->messages['pt'][] = "Preço"; 

        $this->messages['en'][] = "Payment"; 
        $this->messages['it'][] = "Pagamento"; 
        $this->messages['pt'][] = "Pagamento"; 

        $this->messages['en'][] = "Description"; 
        $this->messages['it'][] = "Descrizione"; 
        $this->messages['pt'][] = "Descrição"; 

        $this->messages['en'][] = "Amount"; 
        $this->messages['it'][] = "Quantità"; 
        $this->messages['pt'][] = "Quantidade"; 

        $this->messages['en'][] = "Total"; 
        $this->messages['it'][] = "Totale"; 
        $this->messages['pt'][] = "Total"; 

        $this->messages['en'][] = "Process/Transfer"; 
        $this->messages['it'][] = "Elaborazione/Trasferimento"; 
        $this->messages['pt'][] = "Processado/Transferido:"; 

        $this->messages['en'][] = "Data/Time"; 
        $this->messages['it'][] = "Dati/Ora"; 
        $this->messages['pt'][] = "Data/Hora"; 

        $this->messages['en'][] = "Type payment"; 
        $this->messages['it'][] = "Digita pagamento"; 
        $this->messages['pt'][] = "Tipo de pagamento"; 

        $this->messages['en'][] = "Method"; 
        $this->messages['it'][] = "Metodo"; 
        $this->messages['pt'][] = "Método"; 

        $this->messages['en'][] = "Available date"; 
        $this->messages['it'][] = "Data disponibile"; 
        $this->messages['pt'][] = "Data de disponibilização"; 

        $this->messages['en'][] = "Available value"; 
        $this->messages['it'][] = "Valore disponibile"; 
        $this->messages['pt'][] = "Valor disponível"; 

        $this->messages['en'][] = "Gross amount"; 
        $this->messages['it'][] = "Importo lordo"; 
        $this->messages['pt'][] = "Bruto"; 

        $this->messages['en'][] = "Fee"; 
        $this->messages['it'][] = "Tassa"; 
        $this->messages['pt'][] = "Taxa"; 

        $this->messages['en'][] = "Extra amount"; 
        $this->messages['it'][] = "Importo aggiuntivo"; 
        $this->messages['pt'][] = "Valor extra"; 

        $this->messages['en'][] = "Installments"; 
        $this->messages['it'][] = "Rate"; 
        $this->messages['pt'][] = "Parcelas"; 

        $this->messages['en'][] = "Installment value"; 
        $this->messages['it'][] = "Valore della rata"; 
        $this->messages['pt'][] = "Valor/Parcela"; 

        $this->messages['en'][] = "TEF Type"; 
        $this->messages['it'][] = "Tipo TEF"; 
        $this->messages['pt'][] = "Tipo"; 

        $this->messages['en'][] = "NSU"; 
        $this->messages['it'][] = "NSU"; 
        $this->messages['pt'][] = "NSU"; 

        $this->messages['en'][] = "Autorizathion"; 
        $this->messages['it'][] = "Autorizzazione"; 
        $this->messages['pt'][] = "Autorização"; 

        $this->messages['en'][] = "Type/Id"; 
        $this->messages['it'][] = "Tipo/Id"; 
        $this->messages['pt'][] = "Tipo/Id"; 

        $this->messages['en'][] = "Establishment"; 
        $this->messages['it'][] = "Istituzione"; 
        $this->messages['pt'][] = "Estabelecimento"; 

        $this->messages['en'][] = "Acquire"; 
        $this->messages['it'][] = "Acquisire"; 
        $this->messages['pt'][] = "Adquirente"; 

        $this->messages['en'][] = "E-mail"; 
        $this->messages['it'][] = "E-mail"; 
        $this->messages['pt'][] = "E-mail"; 

        $this->messages['en'][] = "Cell phone"; 
        $this->messages['it'][] = "Cellulare"; 
        $this->messages['pt'][] = "Celular"; 

        $this->messages['en'][] = "Document type"; 
        $this->messages['it'][] = "Tipo di documento"; 
        $this->messages['pt'][] = "Tipo de documento"; 

        $this->messages['en'][] = "Document number"; 
        $this->messages['it'][] = "Numero del documento"; 
        $this->messages['pt'][] = "Número do documento"; 

        $this->messages['en'][] = "Date/Time pix"; 
        $this->messages['it'][] = "Data/Ora pix"; 
        $this->messages['pt'][] = "Data/Hora do Pix"; 

        $this->messages['en'][] = "Pix holder"; 
        $this->messages['it'][] = "Portafoto"; 
        $this->messages['pt'][] = "Proprietário do Pix"; 

        $this->messages['en'][] = "Pix type"; 
        $this->messages['it'][] = "Tipo di foto"; 
        $this->messages['pt'][] = "Tipo do Pix"; 

        $this->messages['en'][] = "Bank name"; 
        $this->messages['it'][] = "Nome della banca"; 
        $this->messages['pt'][] = "Banco"; 

        $this->messages['en'][] = "Agency"; 
        $this->messages['it'][] = "Agenzia"; 
        $this->messages['pt'][] = "Agência"; 

        $this->messages['en'][] = "Account"; 
        $this->messages['it'][] = "Account"; 
        $this->messages['pt'][] = "Conta"; 

        $this->messages['en'][] = "Card number (PAN)"; 
        $this->messages['it'][] = "Numero di carta (PAN)"; 
        $this->messages['pt'][] = "Número do cartão (PAN)"; 

        $this->messages['en'][] = "Preço"; 
        $this->messages['it'][] = "Prezzo"; 
        $this->messages['pt'][] = "Preço"; 

        $this->messages['en'][] = "Payments"; 
        $this->messages['it'][] = "Payments"; 
        $this->messages['pt'][] = "Pagamentos"; 

        $this->messages['en'][] = "Details"; 
        $this->messages['it'][] = "Dettagli"; 
        $this->messages['pt'][] = "Detalhes"; 

        $this->messages['en'][] = "Cobs"; 
        $this->messages['it'][] = "Pannocchie"; 
        $this->messages['pt'][] = "Obs"; 

        $this->messages['en'][] = "Previous"; 
        $this->messages['it'][] = "Precedente"; 
        $this->messages['pt'][] = "Anterior"; 

        $this->messages['en'][] = "Forward"; 
        $this->messages['it'][] = "Inoltrare"; 
        $this->messages['pt'][] = "Transporte"; 

        $this->messages['en'][] = "Hash"; 
        $this->messages['it'][] = "Hash"; 
        $this->messages['pt'][] = "Hash"; 

        $this->messages['en'][] = "Tbwallet id"; 
        $this->messages['it'][] = "Tbwallet id"; 
        $this->messages['pt'][] = "Carteira"; 

        $this->messages['en'][] = "View Statement"; 
        $this->messages['it'][] = "Visualizza dichiarazione"; 
        $this->messages['pt'][] = "Visualização de extrato"; 

        $this->messages['en'][] = "Use Pix"; 
        $this->messages['it'][] = "Usa Pix"; 
        $this->messages['pt'][] = "Usar Pix"; 

        $this->messages['en'][] = "Acquirer"; 
        $this->messages['it'][] = "Acquirente"; 
        $this->messages['pt'][] = "Adquirente"; 

        $this->messages['en'][] = "Pix"; 
        $this->messages['it'][] = "Pix"; 
        $this->messages['pt'][] = "Pix"; 

        $this->messages['en'][] = "Tbblockchains id"; 
        $this->messages['it'][] = "Tbblockchains id"; 
        $this->messages['pt'][] = "Blockchain Id"; 

        $this->messages['en'][] = "Tbhsm id"; 
        $this->messages['it'][] = "Tbhsm id"; 
        $this->messages['pt'][] = "HSM"; 

        $this->messages['en'][] = "Pix-out fee type"; 
        $this->messages['it'][] = "Pix-out fee type"; 
        $this->messages['pt'][] = "Tipo de taxa p/ Pixout"; 

        $this->messages['en'][] = "Pix out fee value"; 
        $this->messages['it'][] = "Pix out fee value"; 
        $this->messages['pt'][] = "Valor da taxa de Pixout"; 

        $this->messages['en'][] = "Cusecustody"; 
        $this->messages['it'][] = "Custodia"; 
        $this->messages['pt'][] = "Usar custódia"; 

        $this->messages['en'][] = "Default/Format"; 
        $this->messages['it'][] = "Predefinito/Formato"; 
        $this->messages['pt'][] = "Formato/Padrão"; 

        $this->messages['en'][] = "Cdefaulttype"; 
        $this->messages['it'][] = "Cdefaulttype"; 
        $this->messages['pt'][] = "Tipo/Padrão"; 

        $this->messages['en'][] = "Max cash back by user"; 
        $this->messages['it'][] = "Massimo rimborso in contanti per utente"; 
        $this->messages['pt'][] = "Cash baxk máximo para usuário"; 

        $this->messages['en'][] = "Ncbavailable"; 
        $this->messages['it'][] = "Ncbavailable"; 
        $this->messages['pt'][] = "Cashback disponível"; 

        $this->messages['en'][] = "Ncbdistributed"; 
        $this->messages['it'][] = "Ncbdistributed"; 
        $this->messages['pt'][] = "Cashback distribuído"; 

        $this->messages['en'][] = "Serviço de comparação de faces"; 
        $this->messages['it'][] = "Servizio di comparazione dei volti"; 
        $this->messages['pt'][] = "Serviço de comparação de faces"; 

        $this->messages['en'][] = "Abertura de cofre"; 
        $this->messages['it'][] = "Abertura de cofre"; 
        $this->messages['pt'][] = "Abertura de cofre"; 

        $this->messages['en'][] = "Max installment"; 
        $this->messages['it'][] = "Rata massima"; 
        $this->messages['pt'][] = "Parcelas máximas"; 

        $this->messages['en'][] = "Installment fee"; 
        $this->messages['it'][] = "Tassa di rata"; 
        $this->messages['pt'][] = "Taxa de parcelamento"; 

        $this->messages['en'][] = "Cmultiapprovals"; 
        $this->messages['it'][] = "Cmultiapprovals"; 
        $this->messages['pt'][] = "Multi-aprovação"; 

        $this->messages['en'][] = "Configuration"; 
        $this->messages['it'][] = "Configurazione"; 
        $this->messages['pt'][] = "Configuração"; 

        $this->messages['en'][] = "Treasury Operations"; 
        $this->messages['it'][] = "Operazioni di Tesoreria"; 
        $this->messages['pt'][] = "Tesouraria movimentação"; 

        $this->messages['en'][] = "Order status:"; 
        $this->messages['it'][] = "Stato dell'ordine:"; 
        $this->messages['pt'][] = "Situação do pedido"; 

        $this->messages['en'][] = "External status:"; 
        $this->messages['it'][] = "Stato esterno"; 
        $this->messages['pt'][] = "Situação externa"; 

        $this->messages['en'][] = "Internal number:"; 
        $this->messages['it'][] = "Numero interno:"; 
        $this->messages['pt'][] = "Número interno:"; 

        $this->messages['en'][] = "Externalid:"; 
        $this->messages['it'][] = "ID esterno:"; 
        $this->messages['pt'][] = "Número externo:"; 

        $this->messages['en'][] = "Third party checkout:"; 
        $this->messages['it'][] = "Pagamento tramite terze parti:"; 
        $this->messages['pt'][] = "Checkout de terceiros:"; 

        $this->messages['en'][] = "Notifications:"; 
        $this->messages['it'][] = "Notifiche:"; 
        $this->messages['pt'][] = "Notificações:"; 

        $this->messages['en'][] = "Webhook link:"; 
        $this->messages['it'][] = "Collegamento al webhook:"; 
        $this->messages['pt'][] = "Webhook:"; 

        $this->messages['en'][] = "Destination phone:"; 
        $this->messages['it'][] = "Telefono di destinazione:"; 
        $this->messages['pt'][] = "Telefone de destino:"; 

        $this->messages['en'][] = "Orders"; 
        $this->messages['it'][] = "Ordini"; 
        $this->messages['pt'][] = "Pedidos"; 

        $this->messages['en'][] = "Order status"; 
        $this->messages['it'][] = "Stato dell'ordine"; 
        $this->messages['pt'][] = "Situação do pedido"; 

        $this->messages['en'][] = "Internal number"; 
        $this->messages['it'][] = "Stato dell'ordine"; 
        $this->messages['pt'][] = "Número interno"; 

        $this->messages['en'][] = "Externalid"; 
        $this->messages['it'][] = "ID esterno"; 
        $this->messages['pt'][] = "Número externo"; 

        $this->messages['en'][] = "Webhook link"; 
        $this->messages['it'][] = "Collegamento al webhook"; 
        $this->messages['pt'][] = "Webhook"; 

        $this->messages['en'][] = "Notifications"; 
        $this->messages['it'][] = "Notifiche"; 
        $this->messages['pt'][] = "Notificações"; 

        $this->messages['en'][] = "Third party checkout"; 
        $this->messages['it'][] = "Pagamento di terze parti"; 
        $this->messages['pt'][] = "Checkout de terceiro"; 

        $this->messages['en'][] = "External status"; 
        $this->messages['it'][] = "Stato esterno"; 
        $this->messages['pt'][] = "Situação/Externa"; 

        $this->messages['en'][] = "Tbtokensale id"; 
        $this->messages['it'][] = "ID Tbtokensale"; 
        $this->messages['pt'][] = "Id"; 

        $this->messages['en'][] = "Cdestphone"; 
        $this->messages['it'][] = "Telefono fisso"; 
        $this->messages['pt'][] = "Telefone de destino"; 

        $this->messages['en'][] = "Processed"; 
        $this->messages['it'][] = "Elaborato"; 
        $this->messages['pt'][] = "Processado"; 

        $this->messages['en'][] = "Gross Value"; 
        $this->messages['it'][] = "Valore lordo"; 
        $this->messages['pt'][] = "Valor bruto"; 

        $this->messages['en'][] = "Cfeetype"; 
        $this->messages['it'][] = "Tipo di tariffa"; 
        $this->messages['pt'][] = "Tipo de taxa"; 

        $this->messages['en'][] = "Initial date:"; 
        $this->messages['it'][] = "Data iniziale:"; 
        $this->messages['pt'][] = "Data inicial:"; 

        $this->messages['en'][] = "Final date:"; 
        $this->messages['it'][] = "Data finale"; 
        $this->messages['pt'][] = "Data final:"; 

        $this->messages['en'][] = "Guid:"; 
        $this->messages['it'][] = "Guid:"; 
        $this->messages['pt'][] = "Guid:"; 

        $this->messages['en'][] = "External client identification:"; 
        $this->messages['it'][] = "Identificazione del cliente esterno:"; 
        $this->messages['pt'][] = "Identificação/Cliente:"; 

        $this->messages['en'][] = "Holders"; 
        $this->messages['it'][] = "Titolari"; 
        $this->messages['pt'][] = "Titulares"; 

        $this->messages['en'][] = "Nid externallocation"; 
        $this->messages['it'][] = "Nid posizione esterna"; 
        $this->messages['pt'][] = "Localização externa"; 

        $this->messages['en'][] = "Ip:"; 
        $this->messages['it'][] = "Ip:"; 
        $this->messages['pt'][] = "Ip:"; 

        $this->messages['en'][] = "Port:"; 
        $this->messages['it'][] = "Port:"; 
        $this->messages['pt'][] = "Porta:"; 

        $this->messages['en'][] = "HSM Model:"; 
        $this->messages['it'][] = "Modello HSM:"; 
        $this->messages['pt'][] = "Modelo do HSM:"; 

        $this->messages['en'][] = "Use shamir/M/N:"; 
        $this->messages['it'][] = "Usa shamir/M/N:"; 
        $this->messages['pt'][] = "Usar Shamir/MdeN:"; 

        $this->messages['en'][] = "caddress"; 
        $this->messages['it'][] = "caddress"; 
        $this->messages['pt'][] = "Endereço"; 

        $this->messages['en'][] = "Symbol"; 
        $this->messages['it'][] = "Simbolo"; 
        $this->messages['pt'][] = "Símbolo"; 

        $this->messages['en'][] = "Decimal place"; 
        $this->messages['it'][] = "Posto decimale"; 
        $this->messages['pt'][] = "Casas decimais"; 

        $this->messages['en'][] = "Project link"; 
        $this->messages['it'][] = "Collegamento al progetto"; 
        $this->messages['pt'][] = "Link do projeto"; 

        $this->messages['en'][] = "Max circulante assets"; 
        $this->messages['it'][] = "Massimo circolante attivo"; 
        $this->messages['pt'][] = "Quantidade circulante"; 

        $this->messages['en'][] = "URL/Icon location"; 
        $this->messages['it'][] = "Posizione URL/Icona"; 
        $this->messages['pt'][] = "URL do ícone"; 

        $this->messages['en'][] = "Subsidiary id"; 
        $this->messages['it'][] = "ID sussidiaria"; 
        $this->messages['pt'][] = "Id/Subsidiario"; 

        $this->messages['en'][] = "N3approvalsmax"; 
        $this->messages['it'][] = "N3approvalsmax"; 
        $this->messages['pt'][] = "Número máximo de aprovações"; 

        $this->messages['en'][] = "ABI"; 
        $this->messages['it'][] = "ABI"; 
        $this->messages['pt'][] = "ABI"; 

        $this->messages['en'][] = "GAS Subsidy"; 
        $this->messages['it'][] = "Sussidio GAS"; 
        $this->messages['pt'][] = "S"; 

        $this->messages['en'][] = "Nspendervalue"; 
        $this->messages['it'][] = "Nspendervalue"; 
        $this->messages['pt'][] = "Subsídio de GAS"; 

        $this->messages['en'][] = "Symbol:"; 
        $this->messages['it'][] = "Simbolo"; 
        $this->messages['pt'][] = "Símbolo"; 

        $this->messages['en'][] = "Assets"; 
        $this->messages['it'][] = "Attività"; 
        $this->messages['pt'][] = "Ativos"; 

        $this->messages['en'][] = "Blockchain Name:"; 
        $this->messages['it'][] = "Nome della blockchain:"; 
        $this->messages['pt'][] = "Nome do blockchain:"; 

        $this->messages['en'][] = "Url for blockscan:"; 
        $this->messages['it'][] = "URL per blockscan:"; 
        $this->messages['pt'][] = "Blockscan:"; 

        $this->messages['en'][] = "Project Home:"; 
        $this->messages['it'][] = "home del progetto:"; 
        $this->messages['pt'][] = "Página do projeto:"; 

        $this->messages['en'][] = "Blockchains"; 
        $this->messages['it'][] = "Blockchains"; 
        $this->messages['pt'][] = "Blockchains"; 

        $this->messages['en'][] = "Blockchain Name"; 
        $this->messages['it'][] = "Nome della blockchain"; 
        $this->messages['pt'][] = "Nome do Blockchain"; 

        $this->messages['en'][] = "Url for blockscan"; 
        $this->messages['it'][] = "URL per blockscan"; 
        $this->messages['pt'][] = "Blockscan"; 

        $this->messages['en'][] = "Project Home"; 
        $this->messages['it'][] = "home del progetto"; 
        $this->messages['pt'][] = "Home do projeto"; 

        $this->messages['en'][] = "RPC"; 
        $this->messages['it'][] = "RPC"; 
        $this->messages['pt'][] = "RPC"; 

        $this->messages['en'][] = "ChainId"; 
        $this->messages['it'][] = "ChainId"; 
        $this->messages['pt'][] = "ChainId"; 

        $this->messages['en'][] = "Ncurrent block"; 
        $this->messages['it'][] = "Blocco non corrente"; 
        $this->messages['pt'][] = "Bloco atual"; 

        $this->messages['en'][] = "Validations"; 
        $this->messages['it'][] = "Convalide"; 
        $this->messages['pt'][] = "Validações"; 

        $this->messages['en'][] = "System user:"; 
        $this->messages['it'][] = "Utente del sistema:"; 
        $this->messages['pt'][] = "Usuário do sistema:"; 

        $this->messages['en'][] = "Date and Time of events:"; 
        $this->messages['it'][] = "Data e ora degli eventi:"; 
        $this->messages['pt'][] = "Data e hora de eventos:"; 

        $this->messages['en'][] = "Logtype:"; 
        $this->messages['it'][] = "Tipo di registro:"; 
        $this->messages['pt'][] = "Tipo de log:"; 

        $this->messages['en'][] = "Logs"; 
        $this->messages['it'][] = "registro"; 
        $this->messages['pt'][] = "Logs"; 

        $this->messages['en'][] = "System user"; 
        $this->messages['it'][] = "Utente del sistema"; 
        $this->messages['pt'][] = "Usuários do sistema"; 

        $this->messages['en'][] = "Date and Time of events"; 
        $this->messages['it'][] = "Data e ora degli eventi"; 
        $this->messages['pt'][] = "Data de hora dos eventos"; 

        $this->messages['en'][] = "Cmemo"; 
        $this->messages['it'][] = "Cmemo"; 
        $this->messages['pt'][] = "Memo"; 

        $this->messages['en'][] = "Logtype"; 
        $this->messages['it'][] = "registro"; 
        $this->messages['pt'][] = "Tipo de log"; 

        $this->messages['en'][] = "Initial date/time:"; 
        $this->messages['it'][] = "Data/ora iniziale:"; 
        $this->messages['pt'][] = "Data/Hora de início"; 

        $this->messages['en'][] = "End date/time:"; 
        $this->messages['it'][] = "Data/ora di fine:"; 
        $this->messages['pt'][] = "Data/Hora final"; 

        $this->messages['en'][] = "View logs"; 
        $this->messages['it'][] = "Visualizza i registri"; 
        $this->messages['pt'][] = "Ver logs"; 

        $this->messages['en'][] = "User shamir/M/N:"; 
        $this->messages['it'][] = "Utente shamir/M/N:"; 
        $this->messages['pt'][] = "Usar Shamires/MdeN:"; 

        $this->messages['en'][] = "Main key:"; 
        $this->messages['it'][] = "Chiave principale:"; 
        $this->messages['pt'][] = "Chave matriz:"; 

        $this->messages['en'][] = "User name:"; 
        $this->messages['it'][] = "Nome utente:"; 
        $this->messages['pt'][] = "Usuário:"; 

        $this->messages['en'][] = "Key derivation"; 
        $this->messages['it'][] = "Derivazione chiave"; 
        $this->messages['pt'][] = "Derivação de chave"; 

        $this->messages['en'][] = "Key name:"; 
        $this->messages['it'][] = "Nome chiave:"; 
        $this->messages['pt'][] = "Nome da chave"; 

        $this->messages['en'][] = "Counter:"; 
        $this->messages['it'][] = "Contatore:"; 
        $this->messages['pt'][] = "Contador:"; 

        $this->messages['en'][] = "Keyname"; 
        $this->messages['it'][] = "Nome chiave"; 
        $this->messages['pt'][] = "Nome da chave"; 

        $this->messages['en'][] = "Counter"; 
        $this->messages['it'][] = "Contatore"; 
        $this->messages['pt'][] = "Contador"; 

        $this->messages['en'][] = "Excluir"; 
        $this->messages['it'][] = "Escluso"; 
        $this->messages['pt'][] = "Delete"; 

        $this->messages['en'][] = "User/Create:"; 
        $this->messages['it'][] = "Utente/Crea:"; 
        $this->messages['pt'][] = "Usuário que criou:"; 

        $this->messages['en'][] = "Date/Hour changed:"; 
        $this->messages['it'][] = "Data/Ora modificata:"; 
        $this->messages['pt'][] = "Data/Hora de alteração:"; 

        $this->messages['en'][] = "User/Change:"; 
        $this->messages['it'][] = "Utente/Modifica:"; 
        $this->messages['pt'][] = "Usuário que alterou:"; 

        $this->messages['en'][] = "Date/Time deletion:"; 
        $this->messages['it'][] = "Cancellazione data/ora:"; 
        $this->messages['pt'][] = "Data/Hora de exclusão:"; 

        $this->messages['en'][] = "User/Deletion:"; 
        $this->messages['it'][] = "Utente/Eliminazione:"; 
        $this->messages['pt'][] = "Usuário/Exclusão:"; 

        $this->messages['en'][] = "HSM (Adm)"; 
        $this->messages['it'][] = "HSM (Adm)"; 
        $this->messages['pt'][] = "HSM (Adm)"; 

        $this->messages['en'][] = "Main key"; 
        $this->messages['it'][] = "Chiave principale"; 
        $this->messages['pt'][] = "Chave matriz"; 

        $this->messages['en'][] = "Derivation keys"; 
        $this->messages['it'][] = "Chiavi di derivazione"; 
        $this->messages['pt'][] = "Derivação de chave"; 

        $this->messages['en'][] = "User access"; 
        $this->messages['it'][] = "Accesso utente"; 
        $this->messages['pt'][] = "Usuário de acesso"; 

        $this->messages['en'][] = "Quantity"; 
        $this->messages['it'][] = "Quantità"; 
        $this->messages['pt'][] = "Quantidade"; 

        $this->messages['en'][] = "Reason for cancellation:"; 
        $this->messages['it'][] = "Motivo della cancellazione:"; 
        $this->messages['pt'][] = "Motivo do cancelamento:"; 

        $this->messages['en'][] = "By confirming the authentication code, the transaction will be canceled."; 
        $this->messages['it'][] = "Confermando il codice di autenticazione, la transazione verrà annullata."; 
        $this->messages['pt'][] = "Confirmando o código de autenticação, a transação será cancelada."; 

        $this->messages['en'][] = "Cancellation"; 
        $this->messages['it'][] = "Cancellazione"; 
        $this->messages['pt'][] = "Cancelado"; 

        $this->messages['en'][] = "Reason for cancellation"; 
        $this->messages['it'][] = "Motivo della cancellazione"; 
        $this->messages['pt'][] = "Motivo do cancelamento"; 

        $this->messages['en'][] = "Uuid"; 
        $this->messages['it'][] = "Uuid"; 
        $this->messages['pt'][] = "UUID"; 

        $this->messages['en'][] = "Exportar"; 
        $this->messages['it'][] = "Esportatore"; 
        $this->messages['pt'][] = "Exportar"; 

        $this->messages['en'][] = "Título do formulário"; 
        $this->messages['it'][] = "Título do formulário"; 
        $this->messages['pt'][] = "Título do formulário"; 

        $this->messages['en'][] = "Overview List"; 
        $this->messages['it'][] = "Elenco panoramica"; 
        $this->messages['pt'][] = "Visão geral Lista"; 

        $this->messages['en'][] = "Number"; 
        $this->messages['it'][] = "Numero"; 
        $this->messages['pt'][] = "Número"; 

        $this->messages['en'][] = "Complement"; 
        $this->messages['it'][] = "Complemento"; 
        $this->messages['pt'][] = "Complemento"; 

        $this->messages['en'][] = "Neighborhood"; 
        $this->messages['it'][] = "Quartiere"; 
        $this->messages['pt'][] = "Bairro"; 

        $this->messages['en'][] = "Holder address"; 
        $this->messages['it'][] = "Indirizzo del titolare"; 
        $this->messages['pt'][] = "Endereço do titular"; 

        $this->messages['en'][] = "End Date:"; 
        $this->messages['it'][] = "Data di fine:"; 
        $this->messages['pt'][] = "Data final:"; 

        $this->messages['en'][] = "Phone:"; 
        $this->messages['it'][] = "Telefono:"; 
        $this->messages['pt'][] = "Celular:"; 

        $this->messages['en'][] = "Person type:"; 
        $this->messages['it'][] = "Tipo di persona:"; 
        $this->messages['pt'][] = "Tipo de pessoa:"; 

        $this->messages['en'][] = "Last interation:"; 
        $this->messages['it'][] = "Ultima interazione:"; 
        $this->messages['pt'][] = "Última interação:"; 

        $this->messages['en'][] = "Lead generation"; 
        $this->messages['it'][] = "Generazione di lead"; 
        $this->messages['pt'][] = "Geração de Lead"; 

        $this->messages['en'][] = "1st approval"; 
        $this->messages['it'][] = "1a approvazione"; 
        $this->messages['pt'][] = "1º Aprovador"; 

        $this->messages['en'][] = "2nd approval"; 
        $this->messages['it'][] = "2a approvazione"; 
        $this->messages['pt'][] = "2º Aprovador"; 

        $this->messages['en'][] = "3rd approval"; 
        $this->messages['it'][] = "3a approvazione"; 
        $this->messages['pt'][] = "3º Aprovador"; 

        $this->messages['en'][] = "4th approval"; 
        $this->messages['it'][] = "4a approvazione"; 
        $this->messages['pt'][] = "4º Aprovador"; 

        $this->messages['en'][] = "Tbholders id"; 
        $this->messages['it'][] = "Tbholders id"; 
        $this->messages['pt'][] = "Cliente"; 

        $this->messages['en'][] = "Due date"; 
        $this->messages['it'][] = "Scadenza"; 
        $this->messages['pt'][] = "Vencimento"; 

        $this->messages['en'][] = "Pix/QRCode"; 
        $this->messages['it'][] = "Pix/QRCode"; 
        $this->messages['pt'][] = "Pix/QRCode"; 

        $this->messages['en'][] = "Total value"; 
        $this->messages['it'][] = "Valore totale"; 
        $this->messages['pt'][] = "Total"; 

        $this->messages['en'][] = "Digitable line"; 
        $this->messages['it'][] = "Linea digitale"; 
        $this->messages['pt'][] = "Linha digitável"; 

        $this->messages['en'][] = "Valores de json utilizados para este boleto"; 
        $this->messages['it'][] = "Valori JSON utilizzati per questo bollettino"; 
        $this->messages['pt'][] = "Valores de json utilizados para este boleto"; 

        $this->messages['en'][] = "Quantity operation"; 
        $this->messages['it'][] = "Operazione di quantità"; 
        $this->messages['pt'][] = "Quantidade/Operação"; 

        $this->messages['en'][] = "IA charges"; 
        $this->messages['it'][] = "Accuse dell'IA"; 
        $this->messages['pt'][] = "Cobranças por IA"; 

        $this->messages['en'][] = "Date from:"; 
        $this->messages['it'][] = "Data da:"; 
        $this->messages['pt'][] = "Data de:"; 

        $this->messages['en'][] = "Date to:"; 
        $this->messages['it'][] = "Data a:"; 
        $this->messages['pt'][] = "Data até:"; 

        $this->messages['en'][] = "Due date from:"; 
        $this->messages['it'][] = "Data di scadenza da:"; 
        $this->messages['pt'][] = "Vencimento de:"; 

        $this->messages['en'][] = "Due date to:"; 
        $this->messages['it'][] = "Data di scadenza a:"; 
        $this->messages['pt'][] = "Vencimento até:"; 

        $this->messages['en'][] = "Invoices"; 
        $this->messages['it'][] = "Fatture"; 
        $this->messages['pt'][] = "Faturas"; 

        $this->messages['en'][] = "Assets:"; 
        $this->messages['it'][] = "Attività:"; 
        $this->messages['pt'][] = "Ativos:"; 

        $this->messages['en'][] = "Descrição:"; 
        $this->messages['it'][] = "Descrizione:"; 
        $this->messages['pt'][] = "Descrião:"; 

        $this->messages['en'][] = "After balance:"; 
        $this->messages['it'][] = "Dopo il saldo:"; 
        $this->messages['pt'][] = "Saldo/Transporte:"; 

        $this->messages['en'][] = "Obs:"; 
        $this->messages['it'][] = "Obs:"; 
        $this->messages['pt'][] = "Observação:"; 

        $this->messages['en'][] = "Before balance:"; 
        $this->messages['it'][] = "Prima del saldo:"; 
        $this->messages['pt'][] = "Balanço/Anterior:"; 

        $this->messages['en'][] = "Statements"; 
        $this->messages['it'][] = "Dichiarazioni"; 
        $this->messages['pt'][] = "Parcelas"; 

        $this->messages['en'][] = "Dbwallet id"; 
        $this->messages['it'][] = "ID Dbwallet"; 
        $this->messages['pt'][] = "Carteiras"; 

        $this->messages['en'][] = "Descrição"; 
        $this->messages['it'][] = "Descrizione"; 
        $this->messages['pt'][] = "Descrição"; 

        $this->messages['en'][] = "Before balance"; 
        $this->messages['it'][] = "Prima dell'equilibrio"; 
        $this->messages['pt'][] = "Saldo/Anterior"; 

        $this->messages['en'][] = "Obs"; 
        $this->messages['it'][] = "Obs"; 
        $this->messages['pt'][] = "Observação"; 

        $this->messages['en'][] = "After balance"; 
        $this->messages['it'][] = "Dopo l'equilibrio"; 
        $this->messages['pt'][] = "Saldo/Transporte:"; 

        $this->messages['en'][] = "Tbpix id"; 
        $this->messages['it'][] = "Pix/Id"; 
        $this->messages['pt'][] = "PIX"; 

        $this->messages['en'][] = "chash"; 
        $this->messages['it'][] = "Hash"; 
        $this->messages['pt'][] = "Hash"; 

        $this->messages['en'][] = "Operator:"; 
        $this->messages['it'][] = "Operatore:"; 
        $this->messages['pt'][] = "Operador:"; 

        $this->messages['en'][] = "Account/Id:"; 
        $this->messages['it'][] = "Account/ID:"; 
        $this->messages['pt'][] = "Id/Conta:"; 

        $this->messages['en'][] = "Pix/In:"; 
        $this->messages['it'][] = "Pix/In:"; 
        $this->messages['pt'][] = "Pix/Entrada:"; 

        $this->messages['en'][] = "Pix/Out:"; 
        $this->messages['it'][] = "Pix/Out:"; 
        $this->messages['pt'][] = "Pix/saída:"; 

        $this->messages['en'][] = "Trio/ClientId:"; 
        $this->messages['it'][] = "Trio/ClientId:"; 
        $this->messages['pt'][] = "ClienteId/Trio:"; 

        $this->messages['en'][] = "Trio/Secret:"; 
        $this->messages['it'][] = "Trio/Secret:"; 
        $this->messages['pt'][] = "Segredo/Trio:"; 

        $this->messages['en'][] = "Trio/Key id:"; 
        $this->messages['it'][] = "Trio/Key id:"; 
        $this->messages['pt'][] = "Id/Chave/Trio:"; 

        $this->messages['en'][] = "Entity:"; 
        $this->messages['it'][] = "Entità:"; 
        $this->messages['pt'][] = "Entidade:"; 

        $this->messages['en'][] = "Pix banks"; 
        $this->messages['it'][] = "Banche Pix"; 
        $this->messages['pt'][] = "Bancos/Operadores"; 

        $this->messages['en'][] = "Context:"; 
        $this->messages['it'][] = "Contesto:"; 
        $this->messages['pt'][] = "Contexto:"; 

        $this->messages['en'][] = "IA contexts"; 
        $this->messages['it'][] = "Contesti IA"; 
        $this->messages['pt'][] = "Contexto para IA"; 

        $this->messages['en'][] = "Lead:"; 
        $this->messages['it'][] = "Guida:"; 
        $this->messages['pt'][] = "Lead:"; 

        $this->messages['en'][] = "Chat:"; 
        $this->messages['it'][] = "Chiacchierata:"; 
        $this->messages['pt'][] = "Chat:"; 

        $this->messages['en'][] = "Chat history"; 
        $this->messages['it'][] = "Cronologia chat"; 
        $this->messages['pt'][] = "Histórico do chat"; 

        $this->messages['en'][] = "Tbleadgeneration id"; 
        $this->messages['it'][] = "Lead/Generation/Id"; 
        $this->messages['pt'][] = "Lead:"; 

        $this->messages['en'][] = "Credit/Aproval:"; 
        $this->messages['it'][] = "Credito/Approvazione:"; 
        $this->messages['pt'][] = "Crédito/Aprovação:"; 

        $this->messages['en'][] = "Justification:"; 
        $this->messages['it'][] = "Giustificazione:"; 
        $this->messages['pt'][] = "Justificativa:"; 

        $this->messages['en'][] = "SERASA:"; 
        $this->messages['it'][] = "SERASA:"; 
        $this->messages['pt'][] = "SERASA:"; 

        $this->messages['en'][] = "Serasa/Return:"; 
        $this->messages['it'][] = "Serasa/Ritorno:"; 
        $this->messages['pt'][] = "Retorno/SERASA:"; 

        $this->messages['en'][] = "Evaluation panel"; 
        $this->messages['it'][] = "Pannello di valutazione"; 
        $this->messages['pt'][] = "Panel de avaliação"; 

        $this->messages['en'][] = "Serasa"; 
        $this->messages['it'][] = "Serasa"; 
        $this->messages['pt'][] = "Serasa"; 

        $this->messages['en'][] = "SERASA"; 
        $this->messages['it'][] = "SERASA"; 
        $this->messages['pt'][] = "SERASA"; 

        $this->messages['en'][] = "Serasa/Return"; 
        $this->messages['it'][] = "Serasa/Ritorno"; 
        $this->messages['pt'][] = "Retorno/Serasa"; 

        $this->messages['en'][] = "Credit/Aproval"; 
        $this->messages['it'][] = "Credito/Approvazione"; 
        $this->messages['pt'][] = "Aprovação de crédito"; 

        $this->messages['en'][] = "Justification"; 
        $this->messages['it'][] = "Giustificazione"; 
        $this->messages['pt'][] = "Justificativa"; 

        $this->messages['en'][] = "Lead"; 
        $this->messages['it'][] = "Guida"; 
        $this->messages['pt'][] = "Lead"; 

        $this->messages['en'][] = "Chat"; 
        $this->messages['it'][] = "Chiacchierata"; 
        $this->messages['pt'][] = "Chat"; 

        $this->messages['en'][] = "Key name"; 
        $this->messages['it'][] = "Nome chiave"; 
        $this->messages['pt'][] = "Nome da chave"; 

        $this->messages['en'][] = "Index"; 
        $this->messages['it'][] = "Index"; 
        $this->messages['pt'][] = "Índice"; 

        $this->messages['en'][] = "Derivation index"; 
        $this->messages['it'][] = "Indice di derivazione"; 
        $this->messages['pt'][] = "Indice de derivação"; 

        $this->messages['en'][] = "Payer:"; 
        $this->messages['it'][] = "Pagatore:"; 
        $this->messages['pt'][] = "Pagador:"; 

        $this->messages['en'][] = "Total value:"; 
        $this->messages['it'][] = "Valore totale:"; 
        $this->messages['pt'][] = "Valor total:"; 

        $this->messages['en'][] = "Date:"; 
        $this->messages['it'][] = "Data:"; 
        $this->messages['pt'][] = "Data:"; 

        $this->messages['en'][] = "Due date:"; 
        $this->messages['it'][] = "Scadenza:"; 
        $this->messages['pt'][] = "Vencimento:"; 

        $this->messages['en'][] = "Invoice"; 
        $this->messages['it'][] = "Fattura"; 
        $this->messages['pt'][] = "Fatura"; 

        $this->messages['en'][] = "Decimal place:"; 
        $this->messages['it'][] = "Posizione decimale:"; 
        $this->messages['pt'][] = "Casas decimais:"; 

        $this->messages['en'][] = "Project link:"; 
        $this->messages['it'][] = "Collegamento al progetto:"; 
        $this->messages['pt'][] = "Link do projeto"; 

        $this->messages['en'][] = "Icon url:"; 
        $this->messages['it'][] = "Icon url:"; 
        $this->messages['pt'][] = "URL do ícone:"; 

        $this->messages['en'][] = "Max circulante assets:"; 
        $this->messages['it'][] = "Massima attività circolante:"; 
        $this->messages['pt'][] = "Circulante máximo:"; 

        $this->messages['en'][] = "Max value for three approvals:"; 
        $this->messages['it'][] = "Valore massimo per tre approvazioni:"; 
        $this->messages['pt'][] = "Valor máximo para três aprovações:"; 

        $this->messages['en'][] = "GAS Subsidy (EIP-2612)"; 
        $this->messages['it'][] = "Sussidio GAS (EIP-2612)"; 
        $this->messages['pt'][] = "Subsídio de GAS (EIP-2612)"; 

        $this->messages['en'][] = "Subsidized transfer:"; 
        $this->messages['it'][] = "Trasferimento sovvenzionato:"; 
        $this->messages['pt'][] = "Transferência subsidiada:"; 

        $this->messages['en'][] = "Gas payer:"; 
        $this->messages['it'][] = "Contribuente del gas:"; 
        $this->messages['pt'][] = "Financiador do GAS:"; 

        $this->messages['en'][] = "Allowed Amount:"; 
        $this->messages['it'][] = "Importo consentito:"; 
        $this->messages['pt'][] = "Quantidade permitida:"; 

        $this->messages['en'][] = "Assets (Adm)"; 
        $this->messages['it'][] = "Attività (ADM)"; 
        $this->messages['pt'][] = "Ativo (Adm)"; 

        $this->messages['en'][] = "Price history"; 
        $this->messages['it'][] = "Storico dei prezzi"; 
        $this->messages['pt'][] = "Histórico de preços"; 

        $this->messages['en'][] = "Reservation (Pool)"; 
        $this->messages['it'][] = "Prenotazione (Piscina)"; 
        $this->messages['pt'][] = "Reservas (Pool)"; 

        $this->messages['en'][] = "Founding date"; 
        $this->messages['it'][] = "Data di fondazione"; 
        $this->messages['pt'][] = "Data de fundação"; 

        $this->messages['en'][] = "Shopping/Id:"; 
        $this->messages['it'][] = "Shopping/Id:"; 
        $this->messages['pt'][] = "Shopping/Id:"; 

        $this->messages['en'][] = "Indications"; 
        $this->messages['it'][] = "Indicazioni"; 
        $this->messages['pt'][] = "Indicações"; 

        $this->messages['en'][] = "Attempts"; 
        $this->messages['it'][] = "Tentative"; 
        $this->messages['pt'][] = "Intenções"; 

        $this->messages['en'][] = "Interations"; 
        $this->messages['it'][] = "Interazioni"; 
        $this->messages['pt'][] = "Interações"; 

        $this->messages['en'][] = "Location"; 
        $this->messages['it'][] = "Posizione"; 
        $this->messages['pt'][] = "Localização"; 

        $this->messages['en'][] = "External partner:"; 
        $this->messages['it'][] = "Partner esterno:"; 
        $this->messages['pt'][] = "Parceiro externo:"; 

        $this->messages['en'][] = "Publick key"; 
        $this->messages['it'][] = "Chiave pubblica"; 
        $this->messages['pt'][] = "Chave pública"; 

        $this->messages['en'][] = "Select"; 
        $this->messages['it'][] = "Selezionare"; 
        $this->messages['pt'][] = "Selecionar"; 

        $this->messages['en'][] = "Format:"; 
        $this->messages['it'][] = "Formato:"; 
        $this->messages['pt'][] = "Formato:"; 

        $this->messages['en'][] = "Search"; 
        $this->messages['it'][] = "Ricerca"; 
        $this->messages['pt'][] = "Localizar"; 

        $this->messages['en'][] = "Select a wallet"; 
        $this->messages['it'][] = "Seleziona un portafoglio"; 
        $this->messages['pt'][] = "Selecionar carteira"; 

        $this->messages['en'][] = "Icon"; 
        $this->messages['it'][] = "Icon"; 
        $this->messages['pt'][] = "Ícone"; 

        $this->messages['en'][] = "Asset name"; 
        $this->messages['it'][] = "Nome della risorsa"; 
        $this->messages['pt'][] = "Nome do ativo"; 

        $this->messages['en'][] = "Ctype"; 
        $this->messages['it'][] = "Tipo "; 
        $this->messages['pt'][] = "Tipo"; 

        $this->messages['en'][] = "Decimals"; 
        $this->messages['it'][] = "Decimali"; 
        $this->messages['pt'][] = "Decimais"; 

        $this->messages['en'][] = "Cpublickey"; 
        $this->messages['it'][] = "Cpublickey"; 
        $this->messages['pt'][] = "Chave pública"; 

        $this->messages['en'][] = "Balance"; 
        $this->messages['it'][] = "Bilancia"; 
        $this->messages['pt'][] = "Balanço"; 

        $this->messages['en'][] = "Enviar"; 
        $this->messages['it'][] = "Invia"; 
        $this->messages['pt'][] = "Enviar"; 

        $this->messages['en'][] = "Banks"; 
        $this->messages['it'][] = "Banche"; 
        $this->messages['pt'][] = "Bancos"; 

        $this->messages['en'][] = "1st approver"; 
        $this->messages['it'][] = "1° approvatore"; 
        $this->messages['pt'][] = "1º Aprovador"; 

        $this->messages['en'][] = "2nd approver"; 
        $this->messages['it'][] = "2° approvatore"; 
        $this->messages['pt'][] = "2º Aprovador"; 

        $this->messages['en'][] = "3rd approver"; 
        $this->messages['it'][] = "Approvazioni"; 
        $this->messages['pt'][] = "3º Aprovador"; 

        $this->messages['en'][] = "Approvals"; 
        $this->messages['it'][] = "Portafoglio"; 
        $this->messages['pt'][] = "Aprovações"; 

        $this->messages['en'][] = "Wallet"; 
        $this->messages['it'][] = "Portafoglio"; 
        $this->messages['pt'][] = "Carteira"; 

        $this->messages['en'][] = "Blochain"; 
        $this->messages['it'][] = "Blockchain"; 
        $this->messages['pt'][] = "Blockchain"; 

        $this->messages['en'][] = "Max circulante amount:"; 
        $this->messages['it'][] = "Quantità massima circolante:"; 
        $this->messages['pt'][] = "Quantidade circulante"; 

        $this->messages['en'][] = "GAS Subsidy  (EIP-2612)"; 
        $this->messages['it'][] = "Sussidio GAS (EIP-2612)"; 
        $this->messages['pt'][] = "Subsídio de GAS (EIP-2612)"; 

        $this->messages['en'][] = "Directors/Approvers"; 
        $this->messages['it'][] = "Direttori/Approvatori"; 
        $this->messages['pt'][] = "Diretories/Aprovadores"; 

        $this->messages['en'][] = "Whitelist approval"; 
        $this->messages['it'][] = "Approvazione della lista bianca"; 
        $this->messages['pt'][] = "Aprovação de Lista-branca"; 

        $this->messages['en'][] = "Trio/Auth"; 
        $this->messages['it'][] = "Trio/Auth"; 
        $this->messages['pt'][] = "Trio/Auth"; 

        $this->messages['en'][] = "Ctrio accountid"; 
        $this->messages['it'][] = "Trio account"; 
        $this->messages['pt'][] = "Trio/Account/Id"; 

        $this->messages['en'][] = "Ctrio keyid"; 
        $this->messages['it'][] = "Trio/Key/Id"; 
        $this->messages['pt'][] = "Trio/Key id"; 

        $this->messages['en'][] = "Entity"; 
        $this->messages['it'][] = "Entità"; 
        $this->messages['pt'][] = "Entidade"; 

        $this->messages['en'][] = "Pix/In"; 
        $this->messages['it'][] = "Pix/In"; 
        $this->messages['pt'][] = "Pix/Entrada"; 

        $this->messages['en'][] = "Pix/Out"; 
        $this->messages['it'][] = "Pix/Out"; 
        $this->messages['pt'][] = "Pix/Saída"; 

        $this->messages['en'][] = "Ctrio clientid"; 
        $this->messages['it'][] = "Ctrio clientid"; 
        $this->messages['pt'][] = "Cliente/Trio"; 

        $this->messages['en'][] = "Context"; 
        $this->messages['it'][] = "Contesto"; 
        $this->messages['pt'][] = "Contexto"; 

        $this->messages['en'][] = "Ia contexts"; 
        $this->messages['it'][] = "Ia contesti"; 
        $this->messages['pt'][] = "Contexto para IA"; 

        $this->messages['en'][] = "RPC:"; 
        $this->messages['it'][] = "RPC:"; 
        $this->messages['pt'][] = "RPC:"; 

        $this->messages['en'][] = "ChainId:"; 
        $this->messages['it'][] = "ChainId:"; 
        $this->messages['pt'][] = "ChainId:"; 

        $this->messages['en'][] = "Validations:"; 
        $this->messages['it'][] = "Convalide:"; 
        $this->messages['pt'][] = "Validações:"; 

        $this->messages['en'][] = "Current/Block:"; 
        $this->messages['it'][] = "Corrente/Blocco:"; 
        $this->messages['pt'][] = "Bloco atual:"; 

        $this->messages['en'][] = "Model:"; 
        $this->messages['it'][] = "Modello:"; 
        $this->messages['pt'][] = "Modelo:"; 

        $this->messages['en'][] = "Date/time deletion:"; 
        $this->messages['it'][] = "Data/ora di cancellazione:"; 
        $this->messages['pt'][] = "Data/hora de exclusão:"; 

        $this->messages['en'][] = "Blockchains (Adm)"; 
        $this->messages['it'][] = "Blockchains (Adm)"; 
        $this->messages['pt'][] = "Blockchains (Adm)"; 

        $this->messages['en'][] = "Blockchains (adm)"; 
        $this->messages['it'][] = "Blockchains (adm)"; 
        $this->messages['pt'][] = "Blockchains (Adm)"; 

        $this->messages['en'][] = "Tbstatement id"; 
        $this->messages['it'][] = "Tbstatement id"; 
        $this->messages['pt'][] = "Extrato"; 

        $this->messages['en'][] = "Tbinvoice id"; 
        $this->messages['it'][] = "Tbinvoice id"; 
        $this->messages['pt'][] = "Fatura"; 

        $this->messages['en'][] = "Payment type"; 
        $this->messages['it'][] = "Tipo di pagamento"; 
        $this->messages['pt'][] = "Tipo"; 

        $this->messages['en'][] = "Installment interest rate "; 
        $this->messages['it'][] = "Tasso di interesse rateale"; 
        $this->messages['pt'][] = "Juros/Parcela"; 

        $this->messages['en'][] = "Late interest rate"; 
        $this->messages['it'][] = "Tasso di interesse di mora"; 
        $this->messages['pt'][] = "Juros/Mora"; 

        $this->messages['en'][] = "Penalty fee"; 
        $this->messages['it'][] = "penale"; 
        $this->messages['pt'][] = "Multa"; 

        $this->messages['en'][] = "Launching date"; 
        $this->messages['it'][] = "Data di lancio"; 
        $this->messages['pt'][] = "Lançamento"; 

        $this->messages['en'][] = "Payment date"; 
        $this->messages['it'][] = "Data di pagamento"; 
        $this->messages['pt'][] = "Pagamento"; 

        $this->messages['en'][] = "Bank code"; 
        $this->messages['it'][] = "Codice bancario"; 
        $this->messages['pt'][] = "Banco"; 

        $this->messages['en'][] = "Bank branch"; 
        $this->messages['it'][] = "filiale bancaria"; 
        $this->messages['pt'][] = "Agência"; 

        $this->messages['en'][] = "Bank account"; 
        $this->messages['it'][] = "Conto bancario"; 
        $this->messages['pt'][] = "Conta"; 

        $this->messages['en'][] = "Closed"; 
        $this->messages['it'][] = "Chiuso"; 
        $this->messages['pt'][] = "Fechado"; 

        $this->messages['en'][] = "Installment number"; 
        $this->messages['it'][] = "Numero di rata"; 
        $this->messages['pt'][] = "Parcela"; 

        $this->messages['en'][] = "Installment gross"; 
        $this->messages['it'][] = "Rata lorda"; 
        $this->messages['pt'][] = "Bruto"; 

        $this->messages['en'][] = "Installment net value"; 
        $this->messages['it'][] = "Valore netto della rata"; 
        $this->messages['pt'][] = "Líquido"; 

        $this->messages['en'][] = "Payment type:"; 
        $this->messages['it'][] = "Tipo di pagamento:"; 
        $this->messages['pt'][] = "Tipo de pagamento:"; 

        $this->messages['en'][] = "Launching date from:"; 
        $this->messages['it'][] = "Data di lancio da:"; 
        $this->messages['pt'][] = "Data de:"; 

        $this->messages['en'][] = "Launching date to:"; 
        $this->messages['it'][] = "Data di lancio:"; 
        $this->messages['pt'][] = "Data até:"; 

        $this->messages['en'][] = "Payment date from:"; 
        $this->messages['it'][] = "Data di pagamento da:"; 
        $this->messages['pt'][] = "Pagamento de:"; 

        $this->messages['en'][] = "Payment date to:"; 
        $this->messages['it'][] = "Data di pagamento a:"; 
        $this->messages['pt'][] = "Pagamento até:"; 

        $this->messages['en'][] = "Payables / Receivables"; 
        $this->messages['it'][] = "Debiti / Crediti"; 
        $this->messages['pt'][] = "Contas a pagar/receber"; 

        $this->messages['en'][] = "Name(From)"; 
        $this->messages['it'][] = "Nome (da)"; 
        $this->messages['pt'][] = "Nome(De)"; 

        $this->messages['en'][] = "Wallet to"; 
        $this->messages['it'][] = "Portafoglio a"; 
        $this->messages['pt'][] = "Carteira de destino"; 

        $this->messages['en'][] = "Nuser changed"; 
        $this->messages['it'][] = "Nuser è cambiato"; 
        $this->messages['pt'][] = "Usuário/Alteração"; 

        $this->messages['en'][] = "From"; 
        $this->messages['it'][] = "Da"; 
        $this->messages['pt'][] = "De"; 

        $this->messages['en'][] = "Name(To)"; 
        $this->messages['it'][] = "Nome (a)"; 
        $this->messages['pt'][] = "Nome(Para)"; 

        $this->messages['en'][] = "To"; 
        $this->messages['it'][] = "A"; 
        $this->messages['pt'][] = "Para"; 

        $this->messages['en'][] = "Amount (Description)"; 
        $this->messages['it'][] = "Importo (Descrizione)"; 
        $this->messages['pt'][] = "Quantidade (Descrição)"; 

        $this->messages['en'][] = "1º Approver"; 
        $this->messages['it'][] = "1° Approvazione"; 
        $this->messages['pt'][] = "1º Aprovador"; 

        $this->messages['en'][] = "Secret"; 
        $this->messages['it'][] = "Segreto"; 
        $this->messages['pt'][] = "Segredo"; 

        $this->messages['en'][] = "2º Approver"; 
        $this->messages['it'][] = "2° Approvazione"; 
        $this->messages['pt'][] = "2º Aprovador"; 

        $this->messages['en'][] = "User secret 2"; 
        $this->messages['it'][] = "Segreto utente 2"; 
        $this->messages['pt'][] = "Segredo(2)"; 

        $this->messages['en'][] = "Reason cancelation"; 
        $this->messages['it'][] = "Motivo della cancellazione"; 
        $this->messages['pt'][] = "Razão do cancelamento"; 

        $this->messages['en'][] = "3º Approver"; 
        $this->messages['it'][] = "3° Approvazione"; 
        $this->messages['pt'][] = "3º Aprovador"; 

        $this->messages['en'][] = "User sec3"; 
        $this->messages['it'][] = "Utente sec3"; 
        $this->messages['pt'][] = "Segredo/3"; 

        $this->messages['en'][] = "4º Approver"; 
        $this->messages['it'][] = "4° Approvazione"; 
        $this->messages['pt'][] = "4º Aprovador"; 

        $this->messages['en'][] = "User sec4"; 
        $this->messages['it'][] = "Utente sec4"; 
        $this->messages['pt'][] = "Segredo 4"; 

        $this->messages['en'][] = "Tbwhitelist id"; 
        $this->messages['it'][] = "Lista bianca"; 
        $this->messages['pt'][] = "Id/Whitelist"; 

        $this->messages['en'][] = "Dddatetimeap1"; 
        $this->messages['it'][] = "Data di approvazione 1"; 
        $this->messages['pt'][] = "Data/Aprov/1"; 

        $this->messages['en'][] = "Dddatetimeap2"; 
        $this->messages['it'][] = "Data di approvazione 2"; 
        $this->messages['pt'][] = "Data/Aprov/2"; 

        $this->messages['en'][] = "Dddatetimeap3"; 
        $this->messages['it'][] = "Data di approvazione 3"; 
        $this->messages['pt'][] = "Data/Aprov/3"; 

        $this->messages['en'][] = "Dddatetimeap4"; 
        $this->messages['it'][] = "Data di approvazione 3"; 
        $this->messages['pt'][] = "Data/Aprov/4"; 

        $this->messages['en'][] = "To/Whitelist"; 
        $this->messages['it'][] = "A/Lista bianca"; 
        $this->messages['pt'][] = "Para/Whitelist"; 

        $this->messages['en'][] = "Cancel"; 
        $this->messages['it'][] = "Cancellare"; 
        $this->messages['pt'][] = "Cancelar"; 

        $this->messages['en'][] = "Approvals (ADM)"; 
        $this->messages['it'][] = "Approvazioni (ADM)"; 
        $this->messages['pt'][] = "Aprovações (ADM)"; 

        $this->messages['en'][] = "Land Proprietors"; 
        $this->messages['it'][] = "Proprietari terrieri"; 
        $this->messages['pt'][] = "Proprietários de terras"; 

        $this->messages['en'][] = "Dbstatement id"; 
        $this->messages['it'][] = "Dbstatement  id"; 
        $this->messages['pt'][] = "Parcelamentos"; 

        $this->messages['en'][] = "Operation description"; 
        $this->messages['it'][] = "Descrizione dell'operazione"; 
        $this->messages['pt'][] = "Descrição da operação"; 

        $this->messages['en'][] = "End to End"; 
        $this->messages['it'][] = "End to End"; 
        $this->messages['pt'][] = "End to End"; 

        $this->messages['en'][] = "Tborderproduct id"; 
        $this->messages['it'][] = "Prodotto/id"; 
        $this->messages['pt'][] = "Order/Id"; 

        $this->messages['en'][] = "Tbapprovals id"; 
        $this->messages['it'][] = "Approvazioni"; 
        $this->messages['pt'][] = "Aprovação"; 

        $this->messages['en'][] = "Cerror"; 
        $this->messages['it'][] = "Errore"; 
        $this->messages['pt'][] = "Erro"; 

        $this->messages['en'][] = "Nonce"; 
        $this->messages['it'][] = "Nonce"; 
        $this->messages['pt'][] = "Nonce"; 

        $this->messages['en'][] = "Transaction Hex/Assinada"; 
        $this->messages['it'][] = "Transazione esadecimale/firmata"; 
        $this->messages['pt'][] = "Transação Hex/Assinada"; 

        $this->messages['en'][] = "Function/Call"; 
        $this->messages['it'][] = "Funzione/Chiamata"; 
        $this->messages['pt'][] = "Função/Chamada"; 

        $this->messages['en'][] = "JSON de entrada"; 
        $this->messages['it'][] = "Inserisci JSON"; 
        $this->messages['pt'][] = "JSon de entrada"; 

        $this->messages['en'][] = "Coutjson"; 
        $this->messages['it'][] = "Uscita JSON"; 
        $this->messages['pt'][] = "JSon de Saída"; 

        $this->messages['en'][] = "Internal id"; 
        $this->messages['it'][] = "identificativo interno"; 
        $this->messages['pt'][] = "ID/Interno"; 

        $this->messages['en'][] = "Dead line/Permit"; 
        $this->messages['it'][] = "Scadenza/Permesso"; 
        $this->messages['pt'][] = "Data final/Permição"; 

        $this->messages['en'][] = "Cr"; 
        $this->messages['it'][] = "R"; 
        $this->messages['pt'][] = "R"; 

        $this->messages['en'][] = "Cs"; 
        $this->messages['it'][] = "S"; 
        $this->messages['pt'][] = "S"; 

        $this->messages['en'][] = "V"; 
        $this->messages['it'][] = "V"; 
        $this->messages['pt'][] = "V"; 

        $this->messages['en'][] = "Transfers"; 
        $this->messages['it'][] = "Trasferimenti"; 
        $this->messages['pt'][] = "Transferências"; 

        $this->messages['en'][] = "External partner"; 
        $this->messages['it'][] = "Socio esterno"; 
        $this->messages['pt'][] = "Parceiro externo"; 

        $this->messages['en'][] = "Asset Owners"; 
        $this->messages['it'][] = "Proprietari di asset"; 
        $this->messages['pt'][] = "Proprietário de ativos"; 

        $this->messages['en'][] = "Signature:"; 
        $this->messages['it'][] = "Firma:"; 
        $this->messages['pt'][] = "Assinatura:"; 

        $this->messages['en'][] = "Timestamp:"; 
        $this->messages['it'][] = "Timestamp:"; 
        $this->messages['pt'][] = "Carimbo/Data:"; 

        $this->messages['en'][] = "Block number:"; 
        $this->messages['it'][] = "Numero di blocco:"; 
        $this->messages['pt'][] = "Número do bloco:"; 

        $this->messages['en'][] = "Transaction hash:"; 
        $this->messages['it'][] = "Hash della transazione:"; 
        $this->messages['pt'][] = "Hash de transação:"; 

        $this->messages['en'][] = "Value/Contract:"; 
        $this->messages['it'][] = "Valore/Contratto:"; 
        $this->messages['pt'][] = "Valor/Contrato:"; 

        $this->messages['en'][] = "Function/Hex:"; 
        $this->messages['it'][] = "Funzione/Esadecimale:"; 
        $this->messages['pt'][] = "Função/Hex:"; 

        $this->messages['en'][] = "Input:"; 
        $this->messages['it'][] = "Ingresso:"; 
        $this->messages['pt'][] = "Entrada:"; 

        $this->messages['en'][] = "Gas:"; 
        $this->messages['it'][] = "Gas:"; 
        $this->messages['pt'][] = "Gas:"; 

        $this->messages['en'][] = "Erro :"; 
        $this->messages['it'][] = "Errore:"; 
        $this->messages['pt'][] = "Erro:"; 

        $this->messages['en'][] = "Call:"; 
        $this->messages['it'][] = "Chiamata:"; 
        $this->messages['pt'][] = "Chamada:"; 

        $this->messages['en'][] = "Signatures"; 
        $this->messages['it'][] = "Firme"; 
        $this->messages['pt'][] = "Assinaturas"; 

        $this->messages['en'][] = "Signature"; 
        $this->messages['it'][] = "Firma"; 
        $this->messages['pt'][] = "Assinatura"; 

        $this->messages['en'][] = "Call"; 
        $this->messages['it'][] = "Chiamata"; 
        $this->messages['pt'][] = "Chamada"; 

        $this->messages['en'][] = "Tbsignatures id"; 
        $this->messages['it'][] = "Firme/Id"; 
        $this->messages['pt'][] = "Assinaturas"; 

        $this->messages['en'][] = "Block"; 
        $this->messages['it'][] = "Bloccare"; 
        $this->messages['pt'][] = "Bloco"; 

        $this->messages['en'][] = "Transaction hash"; 
        $this->messages['it'][] = "Hash della transazione"; 
        $this->messages['pt'][] = "Hash/Transação"; 

        $this->messages['en'][] = "Input"; 
        $this->messages['it'][] = "Ingresso"; 
        $this->messages['pt'][] = "Entrada"; 

        $this->messages['en'][] = "Gas"; 
        $this->messages['it'][] = "Gas"; 
        $this->messages['pt'][] = "Gas"; 

        $this->messages['en'][] = "Function/Hex"; 
        $this->messages['it'][] = "Funzione/Esa"; 
        $this->messages['pt'][] = "Função/Hex"; 

        $this->messages['en'][] = "Value/Contract"; 
        $this->messages['it'][] = "Valore/Contratto"; 
        $this->messages['pt'][] = "Valor/Contrato"; 

        $this->messages['en'][] = "Erro"; 
        $this->messages['it'][] = "Errore"; 
        $this->messages['pt'][] = "Erro"; 

        $this->messages['en'][] = "Block:"; 
        $this->messages['it'][] = "Bloccare:"; 
        $this->messages['pt'][] = "Bloco"; 

        $this->messages['en'][] = "Balance control"; 
        $this->messages['it'][] = "Controllo dell'equilibrio"; 
        $this->messages['pt'][] = "Controle de saldo"; 

        $this->messages['en'][] = "Uuid:"; 
        $this->messages['it'][] = "Uuid:"; 
        $this->messages['pt'][] = "Uuid:"; 

        $this->messages['en'][] = "Use Pix:"; 
        $this->messages['it'][] = "Usa Pix:"; 
        $this->messages['pt'][] = "Usar Pix:"; 

        $this->messages['en'][] = "Use custody:"; 
        $this->messages['it'][] = "Utilizzare la custodia:"; 
        $this->messages['pt'][] = "Usar custódia:"; 

        $this->messages['en'][] = "Pix-out fee type:"; 
        $this->messages['it'][] = "Tipo di commissione Pix-out:"; 
        $this->messages['pt'][] = "Tipo de taxa para pagamento:"; 

        $this->messages['en'][] = "Pix-out fee value:"; 
        $this->messages['it'][] = "Valore della commissione Pix-out:"; 
        $this->messages['pt'][] = "Valor da taxa:"; 

        $this->messages['en'][] = "Face service:"; 
        $this->messages['it'][] = "Servizio viso:"; 
        $this->messages['pt'][] = "Serviço/Facial:"; 

        $this->messages['en'][] = "Minutes to wait for safe opening:"; 
        $this->messages['it'][] = "Minuti di attesa per l'apertura in sicurezza:"; 
        $this->messages['pt'][] = "Minutos a espera para abertura do cofre:"; 

        $this->messages['en'][] = "Use multiapprovals:"; 
        $this->messages['it'][] = "Utilizzare le approvazioni multiple:"; 
        $this->messages['pt'][] = "Usar multiaprovação"; 

        $this->messages['en'][] = "Crawler/Tokens:"; 
        $this->messages['it'][] = "Crawler/Token:"; 
        $this->messages['pt'][] = "Buscar/Tokens:"; 

        $this->messages['en'][] = "**If enabled, all contracts involving the custodied wallets will be registered as assets."; 
        $this->messages['it'][] = "**Se abilitato, tutti i contratti che coinvolgono i portafogli custoditi verranno registrati come asset."; 
        $this->messages['pt'][] = "**Se ativado, todos contratos envolvendo as carteiras custodiadas serão cadastrados como ativos."; 

        $this->messages['en'][] = "IP/Enableds for Pix:"; 
        $this->messages['it'][] = "IP/abilitati per Pix:"; 
        $this->messages['pt'][] = "Ips ativos para Pix:"; 

        $this->messages['en'][] = "Installments for payment/Loan"; 
        $this->messages['it'][] = "Rate di pagamento/Prestito"; 
        $this->messages['pt'][] = "Parcelas para pagamento/Empréstimo"; 

        $this->messages['en'][] = "Max installments:"; 
        $this->messages['it'][] = "Numero massimo di rate:"; 
        $this->messages['pt'][] = "Máximo de parcelas:"; 

        $this->messages['en'][] = "Installment fee:"; 
        $this->messages['it'][] = "Commissione di rateizzazione:"; 
        $this->messages['pt'][] = "Taxa para parcelamento:"; 

        $this->messages['en'][] = "Wallet type:"; 
        $this->messages['it'][] = "Tipo di portafoglio:"; 
        $this->messages['pt'][] = "Tipo de carteira:"; 

        $this->messages['en'][] = "Distributed:"; 
        $this->messages['it'][] = "Distribuito:"; 
        $this->messages['pt'][] = "Distribuído:"; 

        $this->messages['en'][] = "Used:"; 
        $this->messages['it'][] = "Usata:"; 
        $this->messages['pt'][] = "Usado:"; 

        $this->messages['en'][] = "Available:"; 
        $this->messages['it'][] = "Disponibile:"; 
        $this->messages['pt'][] = "Disponível:"; 

        $this->messages['en'][] = "Acquirer:"; 
        $this->messages['it'][] = "Acquirente:"; 
        $this->messages['pt'][] = "Adquirente:"; 

        $this->messages['en'][] = "General"; 
        $this->messages['it'][] = "Generale"; 
        $this->messages['pt'][] = "Geral"; 

        $this->messages['en'][] = "Defaults"; 
        $this->messages['it'][] = "Impostazioni predefinite"; 
        $this->messages['pt'][] = "Padrões"; 

        $this->messages['en'][] = "Cashback"; 
        $this->messages['it'][] = "Rimborso"; 
        $this->messages['pt'][] = "Cashback"; 

        $this->messages['en'][] = "Amount/Representative:"; 
        $this->messages['it'][] = "Importo/Rappresentante:"; 
        $this->messages['pt'][] = "Quantidade/Representativa:"; 

        $this->messages['en'][] = "Function:"; 
        $this->messages['it'][] = "Funzione:"; 
        $this->messages['pt'][] = "Função:"; 

        $this->messages['en'][] = "PIX Details"; 
        $this->messages['it'][] = "Dettagli PIX"; 
        $this->messages['pt'][] = "Detalhes do Pix"; 

        $this->messages['en'][] = "External/Id:"; 
        $this->messages['it'][] = "External/Id:"; 
        $this->messages['pt'][] = "Id externo:"; 

        $this->messages['en'][] = "Insert"; 
        $this->messages['it'][] = "Inserire"; 
        $this->messages['pt'][] = "Inserir"; 

        $this->messages['en'][] = "Adding balance"; 
        $this->messages['it'][] = "Aggiunta di saldo"; 
        $this->messages['pt'][] = "Adição de saldo"; 

        $this->messages['en'][] = "Invoice day:"; 
        $this->messages['it'][] = "Giorno della fattura:"; 
        $this->messages['pt'][] = "Dia para fatura:"; 

        $this->messages['en'][] = "Received cashback:"; 
        $this->messages['it'][] = "Cashback ricevuto:"; 
        $this->messages['pt'][] = "Cashback recebido:"; 

        $this->messages['en'][] = "Used cashback:"; 
        $this->messages['it'][] = "Cashback utilizzato:"; 
        $this->messages['pt'][] = "Cashback usado:"; 

        $this->messages['en'][] = "Holders (Adm)"; 
        $this->messages['it'][] = "Titolari (Adm):"; 
        $this->messages['pt'][] = "Titulares (Adm)"; 

        $this->messages['en'][] = "PIX:"; 
        $this->messages['it'][] = "PIX:"; 
        $this->messages['pt'][] = "PIX:"; 

        $this->messages['en'][] = "Invoice:"; 
        $this->messages['it'][] = "Fattura:"; 
        $this->messages['pt'][] = "Fatura:"; 

        $this->messages['en'][] = "Installment number:"; 
        $this->messages['it'][] = "Numero di rata:"; 
        $this->messages['pt'][] = "Parcela"; 

        $this->messages['en'][] = "Installment gross:"; 
        $this->messages['it'][] = "Rata lorda:"; 
        $this->messages['pt'][] = "Bruto"; 

        $this->messages['en'][] = "Installment net value:"; 
        $this->messages['it'][] = "Valore netto della rata:"; 
        $this->messages['pt'][] = "Líquido"; 

        $this->messages['en'][] = "Installment interest rate :"; 
        $this->messages['it'][] = "Tasso di interesse rateale:"; 
        $this->messages['pt'][] = "Juros/Parcela"; 

        $this->messages['en'][] = "Late interest rate:"; 
        $this->messages['it'][] = "Tasso di interesse di mora:"; 
        $this->messages['pt'][] = "Juro/Mora"; 

        $this->messages['en'][] = "Penalty fee:"; 
        $this->messages['it'][] = "penale:"; 
        $this->messages['pt'][] = "Multa:"; 

        $this->messages['en'][] = "Launching date:"; 
        $this->messages['it'][] = "Data di lancio:"; 
        $this->messages['pt'][] = "Lançamento:"; 

        $this->messages['en'][] = "Payment date:"; 
        $this->messages['it'][] = "Data di pagamento:"; 
        $this->messages['pt'][] = "Pagamento:"; 

        $this->messages['en'][] = "Bank code:"; 
        $this->messages['it'][] = "Codice bancario:"; 
        $this->messages['pt'][] = "Código do banco:"; 

        $this->messages['en'][] = "Bank branch:"; 
        $this->messages['it'][] = "filiale bancaria:"; 
        $this->messages['pt'][] = "Agência:"; 

        $this->messages['en'][] = "Bank account:"; 
        $this->messages['it'][] = "Conto bancario:"; 
        $this->messages['pt'][] = "Conta:"; 

        $this->messages['en'][] = "Closed:"; 
        $this->messages['it'][] = "Chiuso:"; 
        $this->messages['pt'][] = "Fechado:"; 

        $this->messages['en'][] = "Dashboard TerraLogs"; 
        $this->messages['it'][] = "Pannello di controllo TerraLogs"; 
        $this->messages['pt'][] = "Dashboard TerraLogs"; 

        $this->messages['en'][] = "Wallet from:"; 
        $this->messages['it'][] = "Portafoglio da:"; 
        $this->messages['pt'][] = "Carteira de origem:"; 

        $this->messages['en'][] = "Batch shipment:"; 
        $this->messages['it'][] = "Spedizione in lotti:"; 
        $this->messages['pt'][] = "Envio em Lote:"; 

        $this->messages['en'][] = "Attention:"; 
        $this->messages['it'][] = "Attenzione:"; 
        $this->messages['pt'][] = "Atenção:"; 

        $this->messages['en'][] = "Fill in the field by entering one record per line in the format phone number;value, without spaces or symbols. "; 
        $this->messages['it'][] = "Compilare il campo inserendo un record per riga nel formato numero di telefono;valore, senza spazi o simboli."; 
        $this->messages['pt'][] = "Preencha o campo colocando um registro por linha no formato telefone;valor, sem espaços ou símbolos. "; 

        $this->messages['en'][] = "Ex: 11999999999;100.50"; 
        $this->messages['it'][] = "Ex: 11999999999;100.50"; 
        $this->messages['pt'][] = "Ex: 11999999999;100.50"; 

        $this->messages['en'][] = "Batch balance transfer"; 
        $this->messages['it'][] = "Trasferimento del saldo batch"; 
        $this->messages['pt'][] = "Envio de saldo em Lote"; 

        $this->messages['en'][] = "Envio  saldo em Lote "; 
        $this->messages['it'][] = "Trasferimento del saldo batch"; 
        $this->messages['pt'][] = "Envio  saldo em Lote "; 

        $this->messages['en'][] = "Max value:"; 
        $this->messages['it'][] = "Valore massimo:"; 
        $this->messages['pt'][] = "Valor máximo:"; 

        $this->messages['en'][] = "Subsidies for transfers"; 
        $this->messages['it'][] = "Sussidi per i trasferimenti"; 
        $this->messages['pt'][] = "Subsídio para transferências"; 

        $this->messages['en'][] = "Max value"; 
        $this->messages['it'][] = "Valore massimo"; 
        $this->messages['pt'][] = "Valor máximo"; 

        $this->messages['en'][] = "Deadline"; 
        $this->messages['it'][] = "Scadenza"; 
        $this->messages['pt'][] = "Linha final"; 

        $this->messages['en'][] = "Tbtransfers id"; 
        $this->messages['it'][] = "Transfers/Id"; 
        $this->messages['pt'][] = "ID/Confirmação"; 

        $this->messages['en'][] = "Tax beneficiaries"; 
        $this->messages['it'][] = "Beneficiari fiscali"; 
        $this->messages['pt'][] = "Beneficiários de taxas"; 

        $this->messages['en'][] = "Assets (adm)"; 
        $this->messages['it'][] = "Attività (amministrative)"; 
        $this->messages['pt'][] = "Ativo (Adm)"; 

        $this->messages['en'][] = "Block Number"; 
        $this->messages['it'][] = "Block Number"; 
        $this->messages['pt'][] = "Número do bloco:"; 

        $this->messages['en'][] = "Start date"; 
        $this->messages['it'][] = "Start date"; 
        $this->messages['pt'][] = "Data inicial"; 

        $this->messages['en'][] = "End Date"; 
        $this->messages['it'][] = "Data di fine"; 
        $this->messages['pt'][] = "Data final"; 

        $this->messages['en'][] = "Phone"; 
        $this->messages['it'][] = "Telefono"; 
        $this->messages['pt'][] = "Celular"; 

        $this->messages['en'][] = "Last interation"; 
        $this->messages['it'][] = "Ultima interazione"; 
        $this->messages['pt'][] = "Ultima interação"; 

        $this->messages['en'][] = "Package Name"; 
        $this->messages['it'][] = "Nome del pacchetto"; 
        $this->messages['pt'][] = "Nome do pacote"; 

        $this->messages['en'][] = "Price"; 
        $this->messages['it'][] = "Prezzo"; 
        $this->messages['pt'][] = "Preço"; 

        $this->messages['en'][] = "Bonus"; 
        $this->messages['it'][] = "Bonus"; 
        $this->messages['pt'][] = "Bonus"; 

        $this->messages['en'][] = "Internal code"; 
        $this->messages['it'][] = "Codice interno"; 
        $this->messages['pt'][] = "Código interno"; 

        $this->messages['en'][] = "Pay fee type"; 
        $this->messages['it'][] = "Tipo di tariffa di pagamento"; 
        $this->messages['pt'][] = "Tipo/Taxa/Pg"; 

        $this->messages['en'][] = "Pay Fee"; 
        $this->messages['it'][] = "Paga la quota"; 
        $this->messages['pt'][] = "Valor da taxa"; 

        $this->messages['en'][] = "Pool"; 
        $this->messages['it'][] = "Piscina"; 
        $this->messages['pt'][] = "Piscina"; 

        $this->messages['en'][] = "Quantidade minima para execução"; 
        $this->messages['it'][] = "Quantità minima per l'esecuzione"; 
        $this->messages['pt'][] = "Quantidade minima para execução"; 

        $this->messages['en'][] = "Quantidade máxima permitida de venda"; 
        $this->messages['it'][] = "Quantità massima consentita per la vendita"; 
        $this->messages['pt'][] = "Quantidade máxima permitida de venda"; 

        $this->messages['en'][] = "Lock"; 
        $this->messages['it'][] = "Serratura"; 
        $this->messages['pt'][] = "Travado"; 

        $this->messages['en'][] = "End date"; 
        $this->messages['it'][] = "Data di fine"; 
        $this->messages['pt'][] = "Data final"; 

        $this->messages['en'][] = "Vendas até o momento"; 
        $this->messages['it'][] = "Vendite fino ad oggi"; 
        $this->messages['pt'][] = "Vendas até o momento"; 

        $this->messages['en'][] = "Folder URL"; 
        $this->messages['it'][] = "URL della cartella"; 
        $this->messages['pt'][] = "URL / Folder"; 

        $this->messages['en'][] = "Token sales"; 
        $this->messages['it'][] = "Vendita di token"; 
        $this->messages['pt'][] = "Vendas de tokens"; 

        $this->messages['en'][] = "Holders (adm)"; 
        $this->messages['it'][] = "Titolari (amministratore)"; 
        $this->messages['pt'][] = "Titulares (Adm)"; 

        $this->messages['en'][] = "Debit:"; 
        $this->messages['it'][] = "Addebito:"; 
        $this->messages['pt'][] = "Débito:"; 

        $this->messages['en'][] = "1x:"; 
        $this->messages['it'][] = "1x"; 
        $this->messages['pt'][] = "1x:"; 

        $this->messages['en'][] = "7x:"; 
        $this->messages['it'][] = "7x"; 
        $this->messages['pt'][] = "7x:"; 

        $this->messages['en'][] = "2x:"; 
        $this->messages['it'][] = "2x"; 
        $this->messages['pt'][] = "2x:"; 

        $this->messages['en'][] = "8x:"; 
        $this->messages['it'][] = "8x"; 
        $this->messages['pt'][] = "8x:"; 

        $this->messages['en'][] = "3x"; 
        $this->messages['it'][] = "3x"; 
        $this->messages['pt'][] = "3x:"; 

        $this->messages['en'][] = "9x:"; 
        $this->messages['it'][] = "9x"; 
        $this->messages['pt'][] = "9x:"; 

        $this->messages['en'][] = "4x:"; 
        $this->messages['it'][] = "4x"; 
        $this->messages['pt'][] = "4x:"; 

        $this->messages['en'][] = "10x:"; 
        $this->messages['it'][] = "10x"; 
        $this->messages['pt'][] = "10x:"; 

        $this->messages['en'][] = "5x:"; 
        $this->messages['it'][] = "5x"; 
        $this->messages['pt'][] = "5x:"; 

        $this->messages['en'][] = "11x:"; 
        $this->messages['it'][] = "11x"; 
        $this->messages['pt'][] = "11x:"; 

        $this->messages['en'][] = "6x:"; 
        $this->messages['it'][] = "6x"; 
        $this->messages['pt'][] = "6x:"; 

        $this->messages['en'][] = "12x:"; 
        $this->messages['it'][] = "12x"; 
        $this->messages['pt'][] = "12x:"; 

        $this->messages['en'][] = "Card fee"; 
        $this->messages['it'][] = "Commissione sulla carta"; 
        $this->messages['pt'][] = "Taxa de cartão"; 

        $this->messages['en'][] = "Provider"; 
        $this->messages['it'][] = "Fornitore"; 
        $this->messages['pt'][] = "Provedor"; 

        $this->messages['en'][] = "1x"; 
        $this->messages['it'][] = "1x"; 
        $this->messages['pt'][] = "1x"; 

        $this->messages['en'][] = "2x"; 
        $this->messages['it'][] = "2x"; 
        $this->messages['pt'][] = "2x"; 

        $this->messages['en'][] = "N3x"; 
        $this->messages['it'][] = "3x"; 
        $this->messages['pt'][] = "3x"; 

        $this->messages['en'][] = "4x"; 
        $this->messages['it'][] = "4x"; 
        $this->messages['pt'][] = "4x"; 

        $this->messages['en'][] = "5x"; 
        $this->messages['it'][] = "5x"; 
        $this->messages['pt'][] = "5x"; 

        $this->messages['en'][] = "6x"; 
        $this->messages['it'][] = "6x"; 
        $this->messages['pt'][] = "6x"; 

        $this->messages['en'][] = "7x"; 
        $this->messages['it'][] = "7x"; 
        $this->messages['pt'][] = "7x"; 

        $this->messages['en'][] = "8x"; 
        $this->messages['it'][] = "8x"; 
        $this->messages['pt'][] = "8x"; 

        $this->messages['en'][] = "9x"; 
        $this->messages['it'][] = "9x"; 
        $this->messages['pt'][] = "9x"; 

        $this->messages['en'][] = "10x"; 
        $this->messages['it'][] = "10x"; 
        $this->messages['pt'][] = "10x"; 

        $this->messages['en'][] = "11x"; 
        $this->messages['it'][] = "11x"; 
        $this->messages['pt'][] = "11x"; 

        $this->messages['en'][] = "12x"; 
        $this->messages['it'][] = "12x"; 
        $this->messages['pt'][] = "12x"; 

        $this->messages['en'][] = "Debit"; 
        $this->messages['it'][] = "Addebito"; 
        $this->messages['pt'][] = "Débito"; 

        $this->messages['en'][] = "Usage report"; 
        $this->messages['it'][] = "Rapporto di utilizzo"; 
        $this->messages['pt'][] = "Relatorio de uso"; 

        $this->messages['en'][] = "Gift Sales Report"; 
        $this->messages['it'][] = "Rapporto sulle vendite di regali"; 
        $this->messages['pt'][] = "Relatório de vendas Gift"; 

        $this->messages['en'][] = "Overview AJFans"; 
        $this->messages['it'][] = "Panoramica AJFans"; 
        $this->messages['pt'][] = "Visão Geral AJFans"; 

        $this->messages['en'][] = "Linha do tempo"; 
        $this->messages['it'][] = "Cronologia"; 
        $this->messages['pt'][] = "Time line"; 

        $this->messages['en'][] = "Overview Keystone(Clonado)"; 
        $this->messages['it'][] = "Panoramica Keystone (clonato)"; 
        $this->messages['pt'][] = "Overview"; 

        $this->messages['en'][] = "Overview Keystone"; 
        $this->messages['it'][] = "Panoramica Keystone"; 
        $this->messages['pt'][] = "Visão Geral Keystone "; 

        $this->messages['en'][] = "Funil de Credito"; 
        $this->messages['it'][] = "Imbuto di credito"; 
        $this->messages['pt'][] = "Funil de Credito"; 

        $this->messages['en'][] = "Suporte"; 
        $this->messages['it'][] = "Supporto"; 
        $this->messages['pt'][] = "Suporte "; 

        $this->messages['en'][] = "Wallet APP"; 
        $this->messages['it'][] = "APP Portafoglio"; 
        $this->messages['pt'][] = "Wallet APP"; 

        $this->messages['en'][] = "AJFans Financial Report"; 
        $this->messages['it'][] = "Rapporto finanziario di AJFans"; 
        $this->messages['pt'][] = "Relatorio Financeiro AjFans"; 

        $this->messages['en'][] = "Keystone Report"; 
        $this->messages['it'][] = "Rapporto Keystone"; 
        $this->messages['pt'][] = "Relatorio Wallets kesytone"; 

        $this->messages['en'][] = "Overview Terralogs"; 
        $this->messages['it'][] = "Panoramica Terralogs"; 
        $this->messages['pt'][] = "Visão Geral TerraLogs"; 

        $this->messages['en'][] = "Dashboard (ADM)"; 
        $this->messages['it'][] = "Pannello di controllo (ADM)"; 
        $this->messages['pt'][] = "Visão Geral ADM"; 

        $this->messages['en'][] = "Basic"; 
        $this->messages['it'][] = "Di base"; 
        $this->messages['pt'][] = "Básico"; 

        $this->messages['en'][] = "Interactions"; 
        $this->messages['it'][] = "Interazioni"; 
        $this->messages['pt'][] = "Interações"; 

        $this->messages['en'][] = "Configuration (ADM)"; 
        $this->messages['it'][] = "Configurazione (ADM)"; 
        $this->messages['pt'][] = "Configuração (ADM)"; 

        $this->messages['en'][] = "Monitoring"; 
        $this->messages['it'][] = "Monitoraggio"; 
        $this->messages['pt'][] = "Monitoramento"; 

        $this->messages['en'][] = "Orders/Transfers"; 
        $this->messages['it'][] = "Ordini/Trasferimenti"; 
        $this->messages['pt'][] = "Pedidos/Transferências"; 

        $this->messages['en'][] = "Administrative"; 
        $this->messages['it'][] = "Amministrativo"; 
        $this->messages['pt'][] = "Administrativo"; 

        $this->messages['en'][] = "Transfers (Adm)"; 
        $this->messages['it'][] = "Trasferimenti (ADM)"; 
        $this->messages['pt'][] = "Transfências (Adm)"; 

        $this->messages['en'][] = "walletmobile"; 
        $this->messages['it'][] = "portafoglio mobile"; 
        $this->messages['pt'][] = "Walletmobile"; 

        $this->messages['en'][] = "Financials"; 
        $this->messages['it'][] = "Financials"; 
        $this->messages['pt'][] = "Financeiros"; 

        $this->messages['en'][] = "Envio saldo em Lote"; 
        $this->messages['pt'][] = "Envio saldo em Lote"; 

        $this->messages['en'][] = "Inserte batch "; 
        $this->messages['pt'][] = "Inserir lote"; 

        $this->messages['en'][] = " batch data"; 
        $this->messages['pt'][] = "Saldo em Lote"; 

        $this->messages['en'][] = "Adding balance in batch"; 
        $this->messages['pt'][] = " Adicionar Saldo em Lote"; 

        $this->messages['en'][] = "Failed"; 
        $this->messages['pt'][] = "Falhou"; 

        $this->messages['en'][] = "RWA"; 
        $this->messages['pt'][] = "RWA"; 

        $this->messages['en'][] = "Passport"; 
        $this->messages['pt'][] = "Passaporte"; 

        $this->messages['en'][] = "Approved"; 
        $this->messages['pt'][] = "Aprovado"; 

        $this->messages['en'][] = "Waiting"; 
        $this->messages['pt'][] = "Aguardando"; 

        $this->messages['en'][] = "Invalid document:"; 
        $this->messages['pt'][] = "Documento inválido:"; 

        $this->messages['en'][] = "In approval(4)"; 
        $this->messages['pt'][] = "Em aprovação(4)"; 

        $this->messages['en'][] = "In approval(3)"; 
        $this->messages['pt'][] = "Em aprovação(3)"; 

        $this->messages['en'][] = "In approval(2)"; 
        $this->messages['pt'][] = "Em aprovação(2)"; 

        $this->messages['en'][] = "In approval(1)"; 
        $this->messages['pt'][] = "Em aprovação(1)"; 

        $this->messages['en'][] = "Residential"; 
        $this->messages['pt'][] = "Residencial"; 

        $this->messages['en'][] = "Select only one custodial or whitelist wallet!"; 
        $this->messages['pt'][] = "Select only one custodial or whitelist wallet"; 

        $this->messages['en'][] = "There are no more pending changes."; 
        $this->messages['pt'][] = "Não existem mais alterações pendentes."; 

        $this->messages['en'][] = "0-Created"; 
        $this->messages['pt'][] = "0-Criado"; 

        $this->messages['en'][] = "Authentication"; 
        $this->messages['pt'][] = "Autenticação"; 

        $this->messages['en'][] = "Only board enabled!"; 
        $this->messages['pt'][] = "Somente habilitado para diretoria!"; 

        $this->messages['en'][] = "2FA Not enabled for user"; 
        $this->messages['pt'][] = "2FA Não ativado para o usuário"; 

        $this->messages['en'][] = "Authentication error!"; 
        $this->messages['pt'][] = "Erro de autenticação!"; 

        $this->messages['en'][] = "Do you want to reset the password to default ?"; 
        $this->messages['pt'][] = "Deseja realmente resetar a senha?"; 

        $this->messages['en'][] = "Password reset successfully"; 
        $this->messages['pt'][] = "Senha resetada com sucesso!"; 

        $this->messages['en'][] = "Enter the destination wallet!"; 
        $this->messages['pt'][] = "Entre com a carteira de destino!"; 

        $this->messages['en'][] = "Não é possível deletar este registro pois ele está sendo utilizado em outra parte do sistema"; 
        $this->messages['pt'][] = "Não é possível deletar este registro pois ele está sendo utilizado em outra parte do sistema"; 

        $this->messages['en'][] = "Credit"; 
        $this->messages['pt'][] = "Crédito"; 

        $this->messages['en'][] = "CPF"; 
        $this->messages['pt'][] = "CPF"; 

        $this->messages['en'][] = "CNPJ"; 
        $this->messages['pt'][] = "CNPJ"; 

        $this->messages['en'][] = "EVP"; 
        $this->messages['pt'][] = "EVP"; 

        $this->messages['en'][] = "1-Processing"; 
        $this->messages['pt'][] = "1-Processando"; 

        $this->messages['en'][] = "2-Confirmed"; 
        $this->messages['pt'][] = "2-Confirmado"; 

        $this->messages['en'][] = "3-Cancelled"; 
        $this->messages['pt'][] = "3-Cancelado"; 

        $this->messages['en'][] = "4-Reverted"; 
        $this->messages['pt'][] = "4-Revertida"; 

        $this->messages['en'][] = "5-Failed"; 
        $this->messages['pt'][] = "5-Falhou"; 

        $this->messages['en'][] = "One approval"; 
        $this->messages['pt'][] = "Uma aprovação"; 

        $this->messages['en'][] = "Two approvals"; 
        $this->messages['pt'][] = "Duas aprovações"; 

        $this->messages['en'][] = "Three approvals"; 
        $this->messages['pt'][] = "3 Aprovações"; 

        $this->messages['en'][] = "Sent"; 
        $this->messages['pt'][] = "Enviado"; 

        $this->messages['en'][] = "Cancelled"; 
        $this->messages['pt'][] = "Cancelado"; 

        $this->messages['en'][] = "Others"; 
        $this->messages['pt'][] = "Outros"; 

        $this->messages['en'][] = "4-Not acquired"; 
        $this->messages['pt'][] = "4-Não adquirido"; 

        $this->messages['en'][] = "3-Acquired"; 
        $this->messages['pt'][] = "3-Adquirido"; 

        $this->messages['en'][] = "2-In progress"; 
        $this->messages['pt'][] = "2-Em progresso"; 

        $this->messages['en'][] = "1-Started"; 
        $this->messages['pt'][] = "1-Iniciado"; 

        $this->messages['en'][] = "3-Not approved"; 
        $this->messages['pt'][] = "3-Não aprovado"; 

        $this->messages['en'][] = "2-Approved"; 
        $this->messages['pt'][] = "2-Aprovado"; 

        $this->messages['en'][] = "1-Validation/Serasa"; 
        $this->messages['pt'][] = "1-Validação/Serasa"; 

        $this->messages['en'][] = "0-Not started"; 
        $this->messages['pt'][] = "0-Não iniciado"; 

        $this->messages['en'][] = "Normal"; 
        $this->messages['pt'][] = "Normal"; 

        $this->messages['en'][] = "Percentage"; 
        $this->messages['pt'][] = "Percentual"; 

        $this->messages['en'][] = "None"; 
        $this->messages['pt'][] = "Nenhum"; 

        $this->messages['en'][] = "Created"; 
        $this->messages['pt'][] = "Criado"; 

        $this->messages['en'][] = "Processing"; 
        $this->messages['pt'][] = "Processando"; 

        $this->messages['en'][] = "Confirmed"; 
        $this->messages['pt'][] = "Confirmado"; 

        $this->messages['en'][] = "Canceled"; 
        $this->messages['pt'][] = "Cancelado"; 

        $this->messages['en'][] = "Refund"; 
        $this->messages['pt'][] = "Devolvido"; 

        $this->messages['en'][] = "Fail"; 
        $this->messages['pt'][] = "Falhou"; 

        $this->messages['en'][] = "Undefined"; 
        $this->messages['pt'][] = "Indefinido"; 

        $this->messages['en'][] = "Real asset"; 
        $this->messages['pt'][] = "Ativo real"; 

        $this->messages['en'][] = "NFT"; 
        $this->messages['pt'][] = "NFT"; 

        $this->messages['en'][] = "Token"; 
        $this->messages['pt'][] = "Token"; 

        $this->messages['en'][] = "Native"; 
        $this->messages['pt'][] = "Nativo"; 

        $this->messages['en'][] = "Y"; 
        $this->messages['pt'][] = "S"; 

        $this->messages['en'][] = "Financial"; 
        $this->messages['pt'][] = "Financeiro"; 

        $this->messages['en'][] = "Commercial"; 
        $this->messages['pt'][] = "Comercial"; 

        $this->messages['en'][] = "Prefer not to say"; 
        $this->messages['pt'][] = "Prefiro não dizer"; 

        $this->messages['en'][] = "Other"; 
        $this->messages['pt'][] = "Outro"; 

        $this->messages['en'][] = "Female"; 
        $this->messages['pt'][] = "Feminino"; 

        $this->messages['en'][] = "Male"; 
        $this->messages['pt'][] = "Masculino"; 

        $this->messages['en'][] = "Legal entity"; 
        $this->messages['pt'][] = "Jurídica"; 

        $this->messages['en'][] = "Individual"; 
        $this->messages['pt'][] = "Física"; 

        $this->messages['en'][] = "No"; 
        $this->messages['pt'][] = "Não"; 

        $this->messages['en'][] = "Yes"; 
        $this->messages['pt'][] = "Sim"; 

        $this->messages['en'][] = "Destination wallet"; 
        $this->messages['pt'][] = "Wallet Destino"; 

        $this->messages['en'][] = "Invalid API response"; 
        $this->messages['pt'][] = "Resposta da API inválida"; 

        $this->messages['en'][] = "Erro inserting balance"; 
        $this->messages['pt'][] = "Erro inserindo saldo"; 

        $this->messages['en'][] = "Financial Report"; 
        $this->messages['pt'][] = "Relatório financeiro"; 

        $this->messages['en'][] = "Billing"; 
        $this->messages['pt'][] = "Contas"; 

        $this->messages['en'][] = "Unaviable"; 
        $this->messages['pt'][] = "Indisponível"; 

        $this->messages['en'][] = "Expand"; 
        $this->messages['pt'][] = "Expandir"; 

        $this->messages['en'][] = "Payable"; 
        $this->messages['pt'][] = "A pagar"; 

        $this->messages['en'][] = "Receivable"; 
        $this->messages['pt'][] = "A receber"; 

        $this->messages['en'][] = "Pending"; 
        $this->messages['pt'][] = "Pendente"; 

        $this->messages['en'][] = "Overdue"; 
        $this->messages['pt'][] = "Em atraso"; 

        $this->messages['en'][] = "Paid"; 
        $this->messages['pt'][] = "Pago"; 

        $this->messages['en'][] = "Invoiced"; 
        $this->messages['pt'][] = "Faturado"; 

        $this->messages['en'][] = "Debit card"; 
        $this->messages['pt'][] = "Cartão de débito"; 

        $this->messages['en'][] = "Credit card"; 
        $this->messages['pt'][] = "Cartão de crédito"; 

        $this->messages['en'][] = "Bank deposit"; 
        $this->messages['pt'][] = "Depósito bancário"; 

        $this->messages['en'][] = "Bank split"; 
        $this->messages['pt'][] = "Boleto"; 

        $this->messages['en'][] = "Refunded"; 
        $this->messages['pt'][] = "Devolvido"; 

        $this->messages['en'][] = "Pay"; 
        $this->messages['pt'][] = "Pago"; 

        $this->messages['en'][] = "Process cannot be completed, transaction already in error state!"; 
        $this->messages['pt'][] = "Processo não pode ser concluído, transação já em estado de erro!"; 

        $this->messages['en'][] = "Transaction already canceled!"; 
        $this->messages['pt'][] = "Transação já cancelada!"; 

        $this->messages['en'][] = "Registro salvo"; 
        $this->messages['pt'][] = "Registro saldo"; 

        $this->messages['en'][] = "User has already approved this process."; 
        $this->messages['pt'][] = "Usuário já aprovou este processo."; 

        $this->messages['en'][] = "Public key will not be changed for an already authorized wallet!"; 
        $this->messages['pt'][] = "A chave pública não pode ser alterada para uma carteira já autorizada!"; 

        $this->messages['en'][] = "J"; 
        $this->messages['pt'][] = "J"; 

        $this->messages['en'][] = "F"; 
        $this->messages['pt'][] = "F"; 

        $this->messages['en'][] = "Data can no longer be changed. Process already authorized."; 
        $this->messages['pt'][] = "Dados não podem ser alterados. Processo já foi autorizado"; 


        
        foreach ($this->messages as $lang => $messages)
        {
            $this->sourceMessages[$lang] = array_flip( $this->messages[ $lang ] );
        }
    }
    
    /**
     * Returns the singleton instance
     * @return  Instance of self
     */
    public static function getInstance()
    {
        // if there's no instance
        if (empty(self::$instance))
        {
            // creates a new object
            self::$instance = new self;
        }
        // returns the created instance
        return self::$instance;
    }
    
    /**
     * Define the target language
     * @param $lang     Target language index
     */
    public static function setLanguage($lang, $global = true)
    {
        $instance = self::getInstance();
        if (in_array($lang, array_keys($instance->messages)))
        {
            $instance->lang = $lang;
        }
        
        if ($global)
        {
            AdiantiCoreTranslator::setLanguage( $lang );
        }
    }
    
    /**
     * Returns the target language
     * @return Target language index
     */
    public static function getLanguage()
    {
        $instance = self::getInstance();
        return $instance->lang;
    }
    
    /**
     * Translate a word to the target language using external translation service
     * @param $word     Word to be translated
     * @param $source_language Source language (always 'en')
     * @param $param1   Parameter for replacement (^1)
     * @param $param2   Parameter for replacement (^2)
     * @param $param3   Parameter for replacement (^3)
     * @return          Translated word
     */
    public static function translate($word, $source_language, $param1 = NULL, $param2 = NULL, $param3 = NULL)
    {
        // get the target language
        $language = self::getLanguage();
        
        // If language is empty or 'en', return original text without translation
        if (empty($language) || $language === 'en')
        {
            $message = $word;
            
            // Replace parameters
            if (isset($param1))
            {
                $message = str_replace('^1', $param1, $message);
            }
            if (isset($param2))
            {
                $message = str_replace('^2', $param2, $message);
            }
            if (isset($param3))
            {
                $message = str_replace('^3', $param3, $message);
            }
            
            return $message;
        }
        
        // Map 'pt' to 'pb' for the translation service
        $targetLanguage = ($language === 'pt') ? 'pb' : $language;
        
        // Get or create cache file path
        // Use PATH constant if available, otherwise use relative path to /app
        if (defined('PATH'))
        {
            $cacheDir = PATH . '/app/';
        }
        else
        {
            $cacheDir = __DIR__ . '/../../app/';
        }
        
        if (!is_dir($cacheDir))
        {
            mkdir($cacheDir, 0755, true);
        }
        $cacheFile = $cacheDir . $targetLanguage . '.json';
        
        // Load cache if exists
        $cache = [];
        if (file_exists($cacheFile))
        {
            $cacheContent = file_get_contents($cacheFile);
            if ($cacheContent !== false)
            {
                $cache = json_decode($cacheContent, true);
                if (!is_array($cache))
                {
                    $cache = [];
                }
            }
        }
        
        // Check if translation exists in cache
        $message = null;
        if (isset($cache[$word]) && !empty($cache[$word]))
        {
            $message = $cache[$word];
        }
        else
        {
            // Call translation API
            $apiUrl = 'https://translate.c9tech.com.br/translate';
            
            $postData = http_build_query([
                'q' => $word,
                'source' => 'en',
                'target' => $targetLanguage,
                'format' => 'text',
                'alternatives' => 1
            ]);
            
            $ch = curl_init($apiUrl);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'accept: application/json',
                'Content-Type: application/x-www-form-urlencoded'
            ]);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 10);
            
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            
            if ($response !== false && $httpCode === 200)
            {
                $responseData = json_decode($response, true);
                if (isset($responseData['translatedText']) && !empty($responseData['translatedText']))
                {
                    $message = $responseData['translatedText'];
                    
                    // Save to cache
                    $cache[$word] = $message;
                    file_put_contents($cacheFile, json_encode($cache, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
                }
            }
        }
        
        // If translation not found, return original word or error message
        if (empty($message))
        {
            $message = '(!!)' . $word;
        }
        
        // Replace parameters
        if (isset($param1))
        {
            $message = str_replace('^1', $param1, $message);
        }
        if (isset($param2))
        {
            $message = str_replace('^2', $param2, $message);
        }
        if (isset($param3))
        {
            $message = str_replace('^3', $param3, $message);
        }
        
        return $message;
    }
    
    /**
     * Translate a template file
     */
    public static function translateTemplate($template)
    {
        // search by translated words
        if(preg_match_all( '!_t\{(.*?)\}!i', $template, $match ) > 0)
        {
            foreach($match[1] as $word)
            {
                $translated = _t($word);
                $template = str_replace('_t{'.$word.'}', $translated, $template);
            }
        }
        
        if(preg_match_all( '!_tf\{(.*?),\s*(.*?)\}!i', $template, $matches ) > 0)
        {
            foreach($matches[0] as $key => $match)
            {
                $raw        = $matches[0][$key];
                $word       = $matches[1][$key];
                $from       = $matches[2][$key];
                $translated = _tf($word, $from);
                $template = str_replace($raw, $translated, $template);
            }
        }
        return $template;
    }
}

/**
 * Facade to translate words from english
 * @param $word  Word to be translated
 * @param $param1 optional ^1
 * @param $param2 optional ^2
 * @param $param3 optional ^3
 * @return Translated word
 */
function _t($msg, $param1 = null, $param2 = null, $param3 = null)
{
    return ApplicationTranslator::translate($msg, 'en', $param1, $param2, $param3);
}

/**
 * Facade to translate words from specified language
 * @param $word  Word to be translated
 * @param $source_language  Source language
 * @param $param1 optional ^1
 * @param $param2 optional ^2
 * @param $param3 optional ^3
 * @return Translated word
 */
function _tf($msg, $source_language = 'en', $param1 = null, $param2 = null, $param3 = null)
{
    return ApplicationTranslator::translate($msg, $source_language, $param1, $param2, $param3);
}
