<?php
require_once 'init.php';

// AdiantiCoreApplication::setRouter(array('AdiantiRouteTranslator', 'translate'));
BuilderApplication::setVerifyActionPermission('BuilderPermissionService::verifyHasPermission', 'hide');

class TApplication extends AdiantiCoreApplication
{
    public static function run($debug = null)
    {
        new TSession;
        ApplicationTranslator::setLanguage( TSession::getValue('user_language'), true ); // multi-lang
        BuilderTranslator::setLanguage( TSession::getValue('user_language'), true ); // multi-lang
        
        if (! empty($_REQUEST['token_mobile']))
        {
            try
            {
                BuilderMobileService::initSessionFromToken($_REQUEST['token_mobile']);
            }
            catch (Exception $e)
            {
                new TMessage('erro', $e->getMessage());
                return;
            }
        }
   
        // Desencripta IDs automaticamente no $_REQUEST se forem encriptados
        if ($_REQUEST && class_exists('SessionIdEncryption'))
        {
            // Padrões de chaves que podem conter IDs encriptados
            $idPatterns = ['id', '_id', 'id_dest', 'id_to'];
            
            // Itera sobre $_REQUEST para desencriptar IDs
            foreach ($_REQUEST as $key => $value)
            {
                // Verifica se a chave corresponde aos padrões de ID
                $isIdField = false;
                if ($key === 'id' || $key === 'key')
                {
                    $isIdField = true;
                }
                else
                {
                    foreach ($idPatterns as $pattern)
                    {
                        if ($pattern !== 'id' && substr($key, -strlen($pattern)) === $pattern)
                        {
                            $isIdField = true;
                            break;
                        }
                    }
                }
                
                if ($isIdField && !empty($value) && is_string($value))
                {
                    // Verifica se parece ser um ID encriptado
                    if (SessionIdEncryption::isEncrypted($value))
                    {
                        try
                        {
                            // Tenta desencriptar
                            $decrypted = SessionIdEncryption::decryptId($value);
                            // Atualiza o valor no $_REQUEST
                            $_REQUEST[$key] = $decrypted;
                            
                            // Também atualiza em $_GET ou $_POST se existir
                            if (isset($_GET[$key]))
                            {
                                $_GET[$key] = $decrypted;
                            }
                            if (isset($_POST[$key]))
                            {
                                $_POST[$key] = $decrypted;
                            }
                        }
                        catch (Exception $e)
                        {
                            // Se falhar a desencriptação, mantém o valor original
                            // Isso permite que valores não encriptados continuem funcionando
                        }
                    }
                }
            }
        }

        if ($_REQUEST)
        {
            $ini = AdiantiApplicationConfig::get();
            
            $class  = isset($_REQUEST['class']) ? $_REQUEST['class'] : '';
            $method  = isset($_REQUEST['method']) ? $_REQUEST['method'] : '';
            $public = in_array($class, $ini['permission']['public_classes']);
            $public_mobile = in_array($class, array_keys($ini['user_public_pages']??[]));
            $debug  = is_null($debug)? $ini['general']['debug'] : $debug;

            if (TSession::getValue('logged')) // logged
            {
                $programs = (array) TSession::getValue('programs'); // programs with permission
                $programs = array_merge($programs, self::getDefaultPermissions());
                $programs_actions = TSession::getValue('programs_actions');
                
                if($public || $public_mobile)
                {
                    parent::run($debug);
                }
                elseif( (isset($programs_actions[$class][$method]) && $programs_actions[$class][$method] == false) || !isset($programs[$class]) )
                {
                    http_response_code(401);
                    new TMessage('error', _t('Permission denied'));
                }
                elseif( isset($programs[$class]) )
                {
                    parent::run($debug);
                }
            }
            else if ($class == 'LoginForm' || $public )
            {
                parent::run($debug);
            }
            else
            {
                http_response_code(401);
                new TMessage('error', _t('Permission denied'), new TAction(array('LoginForm','onLogout')) );
            }
        }
    }
    
    /**
     * Return default programs for logged users
     */
    public static function getDefaultPermissions()
    {
        return array('Adianti\Base\TStandardSeek' => TRUE,
                     'LoginForm' => TRUE,
                     'AdiantiMultiSearchService' => TRUE,
                     'AdiantiUploaderService' => TRUE,
                     'AdiantiAutocompleteService' => TRUE,
                     'EmptyPage' => TRUE,
                     'MessageList' => TRUE,
                     'SystemDocumentUploaderService' => TRUE,
                     'NotificationList' => TRUE,
                     'SearchBox' => TRUE,
                     'SearchInputBox' => TRUE,
                     'BuilderPageService' => TRUE,
                     'BuilderPageBatchUpdate' => TRUE,
                     'BuilderPermissionUpdate' => TRUE,
                     'BuilderConfigForm' => TRUE,
                     'BuilderConfigList' => TRUE,
                     'BuilderMenuUpdate' => TRUE,
                     'BuilderColumnDiffForm' => TRUE,
                     'BuilderConfirmCommandsDiffForm' => TRUE,
                     'BuilderCustomCssService' => TRUE,
                     'BuilderDatabaseDiffForm' => TRUE,
                     'BuilderTableDiffForm' => TRUE,
                     'BuilderViewsDiffForm' => TRUE,
                     'SystemFrameworkUpdate' => TRUE,
                     'SystemPageService' => TRUE,
                     'SystemPageBatchUpdate' => TRUE,
                     'SystemPermissionUpdate' => TRUE,
                     'SystemMenuUpdate' => TRUE,
                     'SystemChangeUnitForm' => TRUE,
                     'System2FAEmailForm' => TRUE,
                     'System2FAForm' => TRUE,
                     'System2FAGoogleForm' => TRUE,
                     'BuilderService' => TRUE
                    );
    } 
}

TApplication::run();
